package com.example.removetolocal.oldrepel.entity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_scrapnotice_unit
 * 报废通知
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update dev_scrapnotice_unit set delete_tag = 1 where id = ?")
@Table(name = "dev_scrapnotice_unit")
public class DevScrapnoticeUnit {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 关联通知id
	*/
	@Column(name = "noticeId")
	private Integer noticeId;
	/**
	* unit
	*/
	@Column(name = "unit")
	private String unit;
	/**
	* total
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 选择报废的装备Id
	*/
	@Column(name = "devIds")
	private String devIds;
	/**
	* 状态 1.待确认 2.报废中  3.忽略  4.完成
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* optUser
	*/
	@Column(name = "optUser")
	private String optUser;
	/**
	* optTime
	*/
	@Column(name = "optTime")
	private java.util.Date optTime;
	/**
	* 退回意见
	*/
	@Column(name = "opinion")
	private String opinion;

}
