package com.example.removetolocal.oldtrain;

import com.example.removetolocal.newtrain.entity.TrainTheme;
import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_train
 * 专管员培训
*/
@Data
@Entity
@Table(name = "dev_train")
public class DevTrain {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 培训主题
	*/
	@Column(name = "theme")
	private String theme;
	/**
	* 地点
	*/
	@Column(name = "address")
	private String address;
	/**
	* 主办方
	*/
	@Column(name = "host")
	private String host;
	/**
	* 培训开始时间
	*/
	@Column(name = "start_time")
	private java.util.Date startTime;
	/**
	* 培训结束时间
	*/
	@Column(name = "end_time")
	private java.util.Date endTime;
	/**
	* 培训内容
	*/
	@Column(name = "content")
	private String content;
	/**
	* 通知单位
	*/
	@Column(name = "notice_org")
	private String noticeOrg;
	/**
	* 培训状态：1.报名中 2.截止报名 3.结束 4.撤销
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 创建用户
	*/
	@Column(name = "createuser")
	private String createuser;
	/**
	* 创建单位
	*/
	@Column(name = "create_org")
	private String createOrg;
	/**
	* 创建时间
	*/
	@Column(name = "createtime")
	private java.util.Date createtime;
	/**
	* 更新用户
	*/
	@Column(name = "updateuser")
	private String updateuser;
	/**
	* 更新时间
	*/
	@Column(name = "updatetime")
	private java.util.Date updatetime;
	/**
	* 合格分数
	*/
	@Column(name = "passScore")
	private Double passScore;
	/**
	* 考试附件
	*/
	@Column(name = "examFile")
	private String examFile;

	public TrainTheme toTrainTheme(){
		return new TrainTheme(
				theme,
				startTime,
				null,
				null,
				null,
				null,
				startTime,
				endTime,
				address,
				host,
				null,
				null,
				null,
				null,
				null,
				null,
				passScore.intValue(),
				null,
				null,
				null,
				null

		);
	}

}
