package com.example.removetolocal.service.impl;

import com.example.removetolocal.newallot.dao.AllotBillDao;
import com.example.removetolocal.newallot.entity.AllotBill;
import com.example.removetolocal.newback.dao.AllotBackBillDao;
import com.example.removetolocal.newback.entity.AllotBackBill;
import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newdevice.dao.DeviceLogDao;
import com.example.removetolocal.newdevice.domin.DeviceLibrary;
import com.example.removetolocal.newdevice.domin.DeviceLog;
import com.example.removetolocal.newdevice.domin.PackingLibrary;
import com.example.removetolocal.newentity.dao.*;
import com.example.removetolocal.newrepair.dao.RepairBackBillDao;
import com.example.removetolocal.newrepair.dao.RepairBillDao;
import com.example.removetolocal.newrepair.dao.RepairDetailDao;
import com.example.removetolocal.newrepair.dao.RepairSendBillDao;
import com.example.removetolocal.newrepair.entity.RepairBackBill;
import com.example.removetolocal.newrepair.entity.RepairBill;
import com.example.removetolocal.newrepair.entity.RepairDetail;
import com.example.removetolocal.newrepair.entity.RepairSendBill;
import com.example.removetolocal.newselfcheck.dao.SelfCheckBillDao;
import com.example.removetolocal.newselfcheck.entity.SelfCheckBill;
import com.example.removetolocal.newstorage.dao.StorageBillDao;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newstorage.entity.StorageBill;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.newstorage.entity.TaskLog;
import com.example.removetolocal.newtrain.dao.TrainThemeDao;
import com.example.removetolocal.newtrain.dao.TrainUserDao;
import com.example.removetolocal.newuser.dao.*;
import com.example.removetolocal.newuser.domin.*;
import com.example.removetolocal.service.MysqlToSTService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @Author zjm
 * @Description TODO
 * @Date 2020/12/26 上午11:04
 * @Version 1.0
 */
@Slf4j
@Service
public class MysqlToSTServiceImpl implements MysqlToSTService {
    @Autowired
    UserDao userDao;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    MgrcertDao mgrcertDao;
    @Autowired
    AreaDao areaDao;
    @Autowired
    TrainThemeDao trainThemeDao;
    @Autowired
    TrainUserDao trainUserDao;
    @Autowired
    DeviceLogDao deviceLogDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    StorageBillDao storageBillDao;
    @Autowired
    TaskLogDao taskLogDao;
    @Autowired
    SelfCheckBillDao selfCheckBillDao;
    @Autowired
    AllotBillDao allotBillDao;
    @Autowired
    AllotBackBillDao allotBackBillDao;
    @Autowired
    UserRoleDao userRoleDao;
    @Autowired
    RepairBillDao repairBillDao;
    @Autowired
    RepairSendBillDao repairSendBillDao;
    @Autowired
    RepairBackBillDao repairBackBillDao;
    @Autowired
    RepairDetailDao repairDetailDao;
    @Autowired
    com.example.removetolocal.newdevice.dao.DeviceLibraryDao deviceLibraryDao;
    @Autowired
    com.example.removetolocal.newdevice.dao.PackingLibraryDao packingLibraryDao;

    @Autowired
    com.example.removetolocal.newentity.dao.NewUserDao newUserDaoSt;
    @Autowired
    com.example.removetolocal.newentity.dao.NewUnitsDao newUnitsDaoSt;
    @Autowired
    com.example.removetolocal.newentity.dao.NewMgrcertDao newMgrcertDaoSt;
    @Autowired
    com.example.removetolocal.newentity.dao.NewAreaDao newAreaDaoSt;
    @Autowired
    com.example.removetolocal.newentity.dao.NewDeviceLibraryDao newDeviceLibraryDao;
    @Autowired
    com.example.removetolocal.newentity.dao.NewDeviceLogDao newDeviceLogDao;
//    @Autowired
//    com.example.removetolocal.newentity.dao.TrainThemeDao trainThemeDao;
//    @Autowired
//    com.example.removetolocal.newentity.dao.TrainUserDao trainUserDao;
    @Autowired
    NewDeviceLibraryDao newDeviceLibraryDaoSt;
    @Autowired
    NewPackingLibraryDao newPackingLibraryDaoSt;
    @Autowired
    NewTaskDao newTaskDao;
    @Autowired
    NewStorageBillDao newStorageBillDao;
    @Autowired
    NewTaskLogDao newTaskLogDao;
    @Autowired
    NewSelfCheckBillDao newSelfCheckBillDao;
    @Autowired
    NewAllotBillDao newAllotBillDao;
    @Autowired
    NewUserRoleDao newUserRoleDao;
    @Autowired
    NewAllotBackBillDao newAllotBackBillDao;
    @Autowired
    NewRepairBillDao newRepairBillDao;
    @Autowired
    NewRepairSendBillDao newRepairSendBillDao;
    @Autowired
    NewRepairDetailDao newRepairDetailDao;
    @Autowired
    NewRepairBackBillDao newRepairBackBillDao;

    @Override
    public void dbToDb() {
        userToSt();
        log.info("user表迁移成功");
        unitsToSt();
        log.info("units表迁移成功");
        mgrcertToSt();
        log.info("mgrcert表迁移成功");
        areaToSt();
        log.info("area表迁移成功");
        deviceLibraryToSt();
        log.info("device_library表迁移成功");
        packingLibraryToSt();
        log.info("packing_library表迁移成功");
        deviceLogToSt();
        log.info("device_log表迁移成功");
        storageBillToSt();
        log.info("storage_bill表迁移成功");
        selfCheckToSt();
        log.info("self_check表迁移成功");
        allotBillToSt();
        log.info("allot_bill表迁移成功");
        allotBackBillToSt();
        log.info("allot_back_bill表迁移成功");
        taskBillToSt();
        log.info("task_bill表迁移成功");
        taskLogToSt();
        log.info("task_log表迁移成功");
        userRoleToSt();
        log.info("user_role表迁移成功");
        repairBillToSt();
        log.info("repair_bill表迁移成功");
        repairSendBillToSt();
        log.info("repair_send_bill表迁移成功");
        repairBackBillToSt();
        log.info("repair_back_bill表迁移成功");
        repairDetailToSt();
        log.info("repair_detail表迁移成功");
    }

    private void userRoleToSt(){
        newUserRoleDao.saveAll( userRoleDao.findAll().stream().map(UserRole::toST).collect(Collectors.toList()));
    }

    private void userToSt(){
       newUserDaoSt.saveAll( userDao.findAll().stream().map(User::toST).collect(Collectors.toList()));
    }

    private void unitsToSt(){
        newUnitsDaoSt.saveAll( unitsDao.findAll().stream().map(Units::toST).collect(Collectors.toList()));
    }

    private void mgrcertToSt(){
        newMgrcertDaoSt.saveAll( mgrcertDao.findAll().stream().map(Mgrcert::toST).collect(Collectors.toList()));
    }

    private void areaToSt(){
        newAreaDaoSt.saveAll( areaDao.findAll().stream().map(Area::toST).collect(Collectors.toList()));
    }

    private void deviceLibraryToSt(){
        newDeviceLibraryDaoSt.saveAll(deviceLibraryDao.findAll().stream().map(DeviceLibrary::toST).collect(Collectors.toList()));
    }

    private void packingLibraryToSt(){
        newPackingLibraryDaoSt.saveAll( packingLibraryDao.findAll().stream().map(PackingLibrary::toST).collect(Collectors.toList()));
    }

    private void deviceLogToSt(){
        newDeviceLogDao.saveAll(deviceLogDao.findAll().stream().map(DeviceLog::toST).collect(Collectors.toList()));
    }

    private void storageBillToSt(){
        newStorageBillDao.saveAll(storageBillDao.findAll().stream().map(StorageBill::toST).collect(Collectors.toList()));
    }

    private void taskBillToSt(){
        newTaskDao.saveAll(taskDao.findAll().stream().map(Task::toST).collect(Collectors.toList()));
    }

    private void taskLogToSt(){
        newTaskLogDao.saveAll(taskLogDao.findAll().stream().map(TaskLog::toST).collect(Collectors.toList()));
    }

    private void selfCheckToSt(){
        newSelfCheckBillDao.saveAll(selfCheckBillDao.findAll().stream().map(SelfCheckBill::toST).collect(Collectors.toList()));
    }

    private void allotBillToSt(){
        newAllotBillDao.saveAll(allotBillDao.findAll().stream().map(AllotBill::toST).collect(Collectors.toList()));
    }

    private void allotBackBillToSt(){
        newAllotBackBillDao.saveAll(allotBackBillDao.findAll().stream().map(AllotBackBill::toST).collect(Collectors.toList()));
    }

    private void repairBillToSt(){
        newRepairBillDao.saveAll(repairBillDao.findAll().stream().map(RepairBill::toST).collect(Collectors.toList()));
    }

    private void repairSendBillToSt(){
        newRepairSendBillDao.saveAll(repairSendBillDao.findAll().stream().map(RepairSendBill::toST).collect(Collectors.toList()));
    }

    private void repairBackBillToSt(){
        newRepairBackBillDao.saveAll(repairBackBillDao.findAll().stream().map(RepairBackBill::toST).collect(Collectors.toList()));
    }

    private void repairDetailToSt(){
        newRepairDetailDao.saveAll(repairDetailDao.findAll().stream().map(RepairDetail::toST).collect(Collectors.toList()));
    }
}
