package com.example.removetolocal.service.impl;

import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newentity.dao.NewSelfCheckBillDao;
import com.example.removetolocal.newselfcheck.dao.SelfCheckBillDao;
import com.example.removetolocal.newselfcheck.entity.SelfCheckBill;
import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.newstorage.entity.TaskLog;
import com.example.removetolocal.oldentity.DevSelfcheck;
import com.example.removetolocal.oldentity.DevSelfcheckdetail;
import com.example.removetolocal.oldentity.DevTasklog;
import com.example.removetolocal.oldentity.DevTaskmain;
import com.example.removetolocal.oldentity.dao.DevSelfCheckDao;
import com.example.removetolocal.oldentity.dao.DevSelfcheckdetailDao;
import com.example.removetolocal.oldentity.dao.DevTasklogDao;
import com.example.removetolocal.oldentity.dao.DevTaskmainDao;
import com.example.removetolocal.service.SelfCheckService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class SelfCheckServiceImpl implements SelfCheckService {
    @Autowired
    DevSelfCheckDao devSelfCheckDao;
    @Autowired
    DevSelfcheckdetailDao devSelfcheckdetailDao;
    @Autowired
    SelfCheckBillDao selfCheckBillDao;
    @Autowired
    UserService userService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    TaskLogDao taskLogDao;
    @Autowired
    NewSelfCheckBillDao newSelfCheckBillDao;
    /**
     * 自查业务转换
     */
    @Override
    public void moveSelfCheck() {
        //转换账单
        List<DevSelfcheck> devSelfchecks = devSelfCheckDao.findAll();
        devSelfchecks.forEach(devSelfcheck -> {
            //自查装备详情
            List<DevSelfcheckdetail> devSelfcheckdetails = devSelfcheckdetailDao.findAllByMainIdAndResult(devSelfcheck.getId(),0);
            SelfCheckBill selfCheckBill = new SelfCheckBill();
            selfCheckBill.setTitle(devSelfcheck.getTitle());
            selfCheckBill.setOldId(devSelfcheck.getId());
            if (devSelfcheck.getState()!=0){
                selfCheckBill.setCheckTime(devSelfcheck.getCheckDate());
                selfCheckBill.setUseraId(userService.getUserByOldId(devSelfcheck.getCheckUser()).getUserId());
                selfCheckBill.setUserbId(userService.getUserByOldId(devSelfcheck.getConfirmUser()).getUserId());
                if (devSelfcheck.getConfirmTime()!=null) {
                    selfCheckBill.setUpdateTime(devSelfcheck.getConfirmTime());
                }
                else {
                    selfCheckBill.setUpdateTime(devSelfcheck.getCreateTime());
                }
                selfCheckBill.setUpdateUserId(selfCheckBill.getUserbId());
                selfCheckBill.setCheckResult("0x0");
                selfCheckBill.setCheckingCount(devSelfcheckdetails.size());
                selfCheckBill.setCheckedCount(devSelfcheckdetails.size());
                List<Integer> deviceIds = new ArrayList<>();
                devSelfcheckdetails.forEach(devSelfcheckdetail -> {
                    deviceIds.add(deviceLibraryDao.findByOldId(devSelfcheckdetail.getDeviceId()).getId());
                });
                selfCheckBill.setCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                if (devSelfcheck.getState()==1){
                    selfCheckBill.setCheckStatus(0);
                }
                else if (devSelfcheck.getState()==2){
                    selfCheckBill.setCheckStatus(2);
                }
            }
            else {
                selfCheckBill.setCheckStatus(3);
                selfCheckBill.setUpdateTime(devSelfcheck.getCreateTime());
                selfCheckBill.setUpdateUserId(userService.getUserByOldId(devSelfcheck.getCreator()).getUserId());
            }
            selfCheckBill.setCreateUserId(userService.getUserByOldId(devSelfcheck.getCreator()).getUserId());
            selfCheckBill.setCreateTime(devSelfcheck.getCreateTime());
            if (selfCheckBill.getUpdateTime()==null){
                selfCheckBill.setUpdateTime(selfCheckBill.getCreateTime());
            }
            if (devSelfcheck.getCycle()==3) {
                selfCheckBill.setCycle(2);
            }
            else if(devSelfcheck.getCycle()==5){
                selfCheckBill.setCycle(0);
            }
            else if (devSelfcheck.getCycle()==0){
                selfCheckBill.setCycle(3);
            }
            selfCheckBill.setCreateUnitId(userService.getUnitByOldId(devSelfcheck.getCreateCompanyId()).getUnitId());
            selfCheckBill.setCheckUnit(userService.getUnitByOldId(devSelfcheck.getComId()).getName());
            SelfCheckBill selfCheckBill1 = selfCheckBillDao.save(selfCheckBill);
            //转移Task
            DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(9,devSelfcheck.getId());
            TaskBto taskBto = devTaskmain.parseToTaskBto();
            taskBto.setBillId(selfCheckBill1.getId());
            taskBto.setOldId(devTaskmain.getId());
            if (taskBto.getBillStatus()==null){
                if (selfCheckBill1.getCheckStatus()==3){
                    taskBto.setBillStatus(400);
                }
                else if (selfCheckBill1.getCheckStatus()==0){
                    taskBto.setBillStatus(401);
                }
                else {
                    taskBto.setBillStatus(9999);
                }
            }
            Task task = taskDao.save(taskBto.toDo());
            //添加业务日志
            List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
            devTasklogs.forEach(devTasklog -> {
                TaskLog taskLog = new TaskLog();
                taskLog.setCreateTime(devTasklog.getOperateTime());
                taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                taskLog.setUpdateTime(taskLog.getCreateTime());
                taskLog.setUpdateUserId(taskLog.getCreateUserId());
                taskLog.setFileDetail("Ǵ");
                taskLog.setRemark(devTasklog.getNote());
                taskLog.setTaskId(task.getId());
                taskLog.setOldId(devTasklog.getId());
                taskLogDao.save(taskLog);
            });
        });
    }

    @Override
    public void aaa() {
        selfCheckBillDao.findAll().forEach(selfCheckBill -> {
            selfCheckBill.setNewDeviceDetail(null);
            selfCheckBillDao.save(selfCheckBill);
        });
        newSelfCheckBillDao.findAll().forEach(selfCheckBill -> {
            selfCheckBill.setNewDeviceDetail(null);
            newSelfCheckBillDao.save(selfCheckBill);
        });
    }
}
