package com.example.removetolocal.config;


import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

/**
 * @author zjm
 */
@Slf4j
@ComponentScan
@Configuration
public class DataSourceConfig {

    @Primary
    @Bean(name = "locationDataSource")
    @Qualifier("locationDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.local")
    public DataSource primaryDataSource() {
        log.info("本地数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }


    /**
     * Backup data source 备份
     * @return DataSourceBuilder
     */
    @Bean(name = "backupDataSource")
    @Qualifier("backupDataSource")
    @ConfigurationProperties(prefix="spring.datasource.backup")
    public DataSource backupDataSource() {
        log.info("备份数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }



//    /**
//     * 原始数据源
//     */
//    private Map<String, DataSource> createDataSourceMap() throws SQLException {
//        DruidDataSource dataSource = new DruidDataSource();
//        dataSource.setDriverClassName(env.getProperty("spring.datasource.history.driver-class-name"));
//        dataSource.setUrl(env.getProperty("spring.datasource.history.url"));
//        dataSource.setUsername(env.getProperty("spring.datasource.history.username"));
//        dataSource.setPassword(env.getProperty("spring.datasource.history.password"));
//
//
//        dataSource.setDbType("mysql");
//        dataSource.setInitialSize(4);
//        dataSource.setMinIdle(4);
//        dataSource.setMaxActive(20);
//
//        /* 配置获取连接等待超时的时间 */
//        dataSource.setMaxWait(60000);
//
//        /* 配置间隔多久才进行一次检测，检测需要关闭的空闲连接，单位是毫秒 */
//        dataSource.setTimeBetweenEvictionRunsMillis(60000);
//
//        /* 配置一个连接在池中最小生存的时间，单位是毫秒 */
//        dataSource.setMinEvictableIdleTimeMillis(300000);
//
//        dataSource.setValidationQuery("SELECT 'x'");
//        dataSource.setTestWhileIdle(true);
//        dataSource.setTestOnBorrow(true);
//        dataSource.setTestOnReturn(false);
//
//        /* 打开PSCache，并且指定每个连接上PSCache的大小。
//           如果用Oracle，则把poolPreparedStatements配置为true，
//           mysql可以配置为false。分库分表较多的数据库，建议配置为false */
//        dataSource.setPoolPreparedStatements(false);
//        dataSource.setMaxPoolPreparedStatementPerConnectionSize(20);
//
//        /* 配置监控统计拦截的filters */
//        dataSource.setFilters("stat,wall,log4j");
//
//        Map<String, DataSource> result = new HashMap<>();
//        result.put("ds0", dataSource);
//        return result;
//    }

}
