package com.example.removetolocal.config.base;


import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
public class GlobalMap {

    private static final Map<Integer, MatchingRange> matchingRangeMap;

    private static final Map<Integer, DeviceInvisibleRange> deviceInvisibleRangeMap;

    private static final Map<Integer,DeviceSecretLevel> deviceSecretLevelMap;

    private static final Map<Integer, DeviceStyle> deviceStyleMap;

    static {
        deviceStyleMap = Arrays.stream(DeviceStyle.values())
                .collect(Collectors.toMap(deviceStyle -> deviceStyle.id, Function.identity()));
        matchingRangeMap = Arrays.stream(MatchingRange.values())
                .collect(Collectors.toMap(matchingRange -> matchingRange.id, Function.identity()));
        deviceInvisibleRangeMap = Arrays.stream(DeviceInvisibleRange.values())
                .collect(Collectors.toMap(deviceInvisibleRange -> deviceInvisibleRange.id, Function.identity()));
        deviceSecretLevelMap = Arrays.stream(DeviceSecretLevel.values())
                .collect(Collectors.toMap(deviceSecretLevel -> deviceSecretLevel.id, Function.identity()));
    }

    public static Map<Integer, DeviceStyle> getDeviceStyleMap() {
        return deviceStyleMap;
    }

    public static Map<Integer, MatchingRange> getMatchingRangeMap() {
        return matchingRangeMap;
    }

    public static Map<Integer, DeviceSecretLevel> getDeviceSecretLevelMap() {
        return deviceSecretLevelMap;
    }

    public static Map<Integer, DeviceInvisibleRange> getDeviceInvisibleRangeMap() {
        return deviceInvisibleRangeMap;
    }

}
