package com.example.removetolocal.newallot.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.Data;
import javax.persistence.*;

import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for allot_bill
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "allot_bill")
public class AllotBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* allotCheckDetail
	*/
	@Column(name = "allot_check_detail",columnDefinition = "TEXT")
	private String allotCheckDetail;
	/**
	* allotCheckResult
	*/
	@Column(name = "allot_check_result")
	private String allotCheckResult;
	/**
	* allotCount
	*/
	@Column(name = "allot_count")
	private Integer allotCount;
	/**
	* allotStatus
	*/
	@Column(name = "allot_status")
	private Integer allotStatus;
	/**
	* allotType
	*/
	@Column(name = "allot_type")
	private Integer allotType;
	/**
	* allotedCount
	*/
	@Column(name = "alloted_count")
	private Integer allotedCount;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* billFileName
	*/
	@Column(name = "bill_file_name")
	private String billFileName;
	/**
	* billFileUrl
	*/
	@Column(name = "bill_file_url")
	private String billFileUrl;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leftSignatureId
	*/
	@Column(name = "left_signature_id")
	private String leftSignatureId;
	/**
	* num
	*/
	@Column(name = "num")
	private String num;
	/**
	* receiveCheckDetail
	*/
	@Column(name = "receive_check_detail",columnDefinition = "TEXT")
	private String receiveCheckDetail;
	/**
	* receiveCheckResult
	*/
	@Column(name = "receive_check_result")
	private String receiveCheckResult;
	/**
	* receiveCount
	*/
	@Column(name = "receive_count")
	private Integer receiveCount;
	/**
	* receiveFileName
	*/
	@Column(name = "receive_file_name")
	private String receiveFileName;
	/**
	* receiveFileUrl
	*/
	@Column(name = "receive_file_url")
	private String receiveFileUrl;
	/**
	* receiveTime
	*/
	@Column(name = "receive_time")
	private java.util.Date receiveTime;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* receiveUseraId
	*/
	@Column(name = "receive_usera_id")
	private Integer receiveUseraId;
	/**
	* receiveUserbId
	*/
	@Column(name = "receive_userb_id")
	private Integer receiveUserbId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* rightSignatureId
	*/
	@Column(name = "right_signature_id")
	private String rightSignatureId;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private java.util.Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendUseraId
	*/
	@Column(name = "send_usera_id")
	private Integer sendUseraId;
	/**
	* sendUserbId
	*/
	@Column(name = "send_userb_id")
	private Integer sendUserbId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

	@Column(name = "old_id")
	private Integer oldId;

	public com.example.removetolocal.newentity.entity.AllotBill toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.AllotBill.class);
	}
}
