package com.example.removetolocal.newentity.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Area.java
 * @Description 地区
 * @createTime 2020年07月28日 09:46:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class Area {
    /**
     * 区域id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 区域名称
     */
    private String name;

    /**
     * 等级 等级 0国家级 1省级 2市级 3县级
     */
    private Integer type;

    /**
     * 排序
     */
    private String orders;

    /**
     * 父类id
     */
    @Column(name = "father_id")
    private Integer fatherId;

    @Column(name = "old_id")
    private String oldId;

}
