package com.example.removetolocal.newentity.entity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for device_repel_detail
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "device_repel_detail")
public class DeviceRepelDetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* auditingFeedback
	*/
	@Column(name = "auditing_feedback",columnDefinition = "TEXT")
	private String auditingFeedback;
	/**
	* billFileName
	*/
	@Column(name = "bill_file_name")
	private String billFileName;
	/**
	* billFileUrl
	*/
	@Column(name = "bill_file_url")
	private String billFileUrl;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceIds
	*/
	@Column(name = "device_ids",columnDefinition = "TEXT")
	private String deviceIds;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leftSignatureId
	*/
	@Column(name = "left_signature_id")
	private String leftSignatureId;
	/**
	* num
	*/
	@Column(name = "num")
	private String num;
	/**
	* receiveCheckDetail
	*/
	@Column(name = "receive_check_detail",columnDefinition = "TEXT")
	private String receiveCheckDetail;
	/**
	* receiveCheckResult
	*/
	@Column(name = "receive_check_result")
	private String receiveCheckResult;
	/**
	* receiveCount
	*/
	@Column(name = "receive_count")
	private Integer receiveCount;
	/**
	* receiveTime
	*/
	@Column(name = "receive_time")
	private java.util.Date receiveTime;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* receiveUseraid
	*/
	@Column(name = "receive_useraid")
	private Integer receiveUseraid;
	/**
	* receiveUseraname
	*/
	@Column(name = "receive_useraname")
	private String receiveUseraname;
	/**
	* receiveUserbid
	*/
	@Column(name = "receive_userbid")
	private Integer receiveUserbid;
	/**
	* receiveUserbname
	*/
	@Column(name = "receive_userbname")
	private String receiveUserbname;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;
	/**
	* repairDeviceDetail
	*/
	@Column(name = "repair_device_detail",columnDefinition = "TEXT")
	private String repairDeviceDetail;
	/**
	* repelId
	*/
	@Column(name = "repel_id")
	private Integer repelId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* rightSignatureId
	*/
	@Column(name = "right_signature_id")
	private String rightSignatureId;
	/**
	* sendBackCount
	*/
	@Column(name = "send_back_count")
	private Integer sendBackCount;
	/**
	* sendBackStatus
	*/
	@Column(name = "send_back_status")
	private Integer sendBackStatus;
	/**
	* sendCheckDetail
	*/
	@Column(name = "send_check_detail",columnDefinition = "TEXT")
	private String sendCheckDetail;
	/**
	* sendCheckResult
	*/
	@Column(name = "send_check_result")
	private String sendCheckResult;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private java.util.Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendUseraid
	*/
	@Column(name = "send_useraid")
	private Integer sendUseraid;
	/**
	* sendUseraname
	*/
	@Column(name = "send_useraname")
	private String sendUseraname;
	/**
	* sendUserbid
	*/
	@Column(name = "send_userbid")
	private Integer sendUserbid;
	/**
	* sendUserbname
	*/
	@Column(name = "send_userbname")
	private String sendUserbname;
	/**
	* sendedCount
	*/
	@Column(name = "sended_count")
	private Integer sendedCount;
	/**
	* submitDescription
	*/
	@Column(name = "submit_description",columnDefinition = "TEXT")
	private String submitDescription;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* billFile
	*/
	@Column(name = "bill_file",columnDefinition = "TEXT")
	private String billFile;
	/**
	* outboundFile
	*/
	@Column(name = "outbound_file",columnDefinition = "TEXT")
	private String outboundFile;
	/**
	* receiveUnitId
	*/
	@Column(name = "receive_unit_id")
	private Integer receiveUnitId;
	/**
	* sendUnitId
	*/
	@Column(name = "send_unit_id")
	private Integer sendUnitId;
	/**
	* inFile
	*/
	@Column(name = "in_file",columnDefinition = "TEXT")
	private String inFile;
	/**
	* repelStatus
	*/
	@Column(name = "repel_status")
	private Integer repelStatus;

	@Column(name = "reply_files",columnDefinition = "TEXT")
	private String replyFiles;

	@Column(name = "send_files",columnDefinition = "TEXT")
	private String sendFiles;
}
