package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for input_output_device
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "input_output_device")
public class InputOutputDevice {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* direction
	*/
	@Column(name = "direction")
	private Integer direction;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* isRead
	*/
	@Column(name = "is_read")
	private Integer isRead;
	/**
	* rfidCardId
	*/
	@Column(name = "rfid_card_id")
	private String rfidCardId;
	/**
	* unitId
	*/
	@Column(name = "unit_id")
	private Integer unitId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
