package com.example.removetolocal.newentity.entity;

import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for packing_library
 * 列装库
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "packing_library")
public class PackingLibrary {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    /**
     * 经办人省A岗id
     */
    @Column(name = "usera_id")
    private Integer useraId;
    /**
     * 审核人省B岗id
     */
    @Column(name = "userb_id")
    private Integer userbId;
    /**
     * 是不是配件(0:不是，1:是)
     */
    @Column(name = "is_part")
    private Integer isPart;

    @Column(name = "is_root")
    private Integer isRoot;

    @Column(name = "show_order")
    private Integer showOrder;

    private Integer style;
    /**
     * 配件对应装备列装id
     */
    @Column(name = "part_parent_id")
    private Integer partParentId;
    /**
     * 列装状态(0:待审核,1:审核失败,2:审核成功待确认,3:已列装,4:已退装)
     */
    @Column(name = "packing_status")
    private Integer packingStatus;
    /**
     * 型号
     */
    private String model;
    /**
     * 密级
     */
    @Column(name = "secret_level")
    private Integer secretLevel;
    /**
     * 名称
     */
    private String name;
    /**
     * 应用类型
     */
    @Column(name = "apply_type")
    private Integer applyType;
    /**
     * 配用范围
     */
    @Column(name = "matching_range")
    private Integer matchingRange;
    /**
     * 可见范围
     */
    @Column(name = "invisible_range")
    private Integer invisibleRange;
    /**
     * 形态
     */
    private Integer type;
    /**
     * 列装性质
     */
    private Integer nature;
    /**
     * 列装状态
     */
    private Integer status;
    /**
     * 生产单位
     */
    @Column(name = "prod_unit")
    private String prodUnit;
    /**
     * 创建单位
     */
    @Column(name = "create_unit")
    private String createUnit;
    /**
     * 价格
     */
    private String price;
    /**
     * 图片名称
     */
    @Column(name = "image_name")
    private String imageName;
    /**
     * 图片url地址
     */
    @Column(name = "image_url")
    private String imageUrl;
    /**
     * 附件名称
     */
    @Column(name = "file_name")
    private String fileName;
    /**
     * 附件url地址
     */
    @Column(name = "file_url")
    private String fileUrl;
    /**
     * 退装时间
     */
    @Column(name = "exit_time")
    private java.sql.Timestamp exitTime;


    @Column(name = "record_id")
    private String recordId;
    /**
     * 创建用户id
     */
    @CreatedBy
    @Column(name = "create_user_id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @Column(name = "update_user_id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @Column(name = "delete_tag")
    private Integer deleteTag = 0;

    @Column(name = "old_id")
    private Integer oldId;
}
