package com.example.removetolocal.newentity.entity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for repel_task_statistical
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "repel_task_statistical")
public class RepelTaskStatistical {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* areaName
	*/
	@Column(name = "area_name")
	private String areaName;
	/**
	* fatherTaskId
	*/
	@Column(name = "father_task_id")
	private Integer fatherTaskId;
	/**
	* modelCount
	*/
	@Column(name = "model_count",columnDefinition = "TEXT")
	private String modelCount;
	/**
	* repelId
	*/
	@Column(name = "repel_id")
	private Integer repelId;
	/**
	* taskId
	*/
	@Column(name = "task_id")
	private Integer taskId;
	/**
	* taskStatus
	*/
	@Column(name = "task_status")
	private Integer taskStatus;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* des
	*/
	@Column(name = "des",columnDefinition = "TEXT")
	private String des;

}
