package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for self_check_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "self_check_bill")
public class SelfCheckBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* checkDetail
	*/
	@Column(name = "check_detail",columnDefinition="TEXT")
	private String checkDetail;
	/**
	* checkResult
	*/
	@Column(name = "check_result")
	private String checkResult;
	/**
	* checkStatus
	*/
	@Column(name = "check_status")
	private Integer checkStatus;
	/**
	* checkTime
	*/
	@Column(name = "check_time")
	private Date checkTime;
	/**
	* checkUnit
	*/
	@Column(name = "check_unit")
	private String checkUnit;
	/**
	* checkedCount
	*/
	@Column(name = "checked_count")
	private Integer checkedCount;
	/**
	* checkingCount
	*/
	@Column(name = "checking_count")
	private Integer checkingCount;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUnitId
	*/
	@Column(name = "create_unit_id")
	private Integer createUnitId;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* cycle
	*/
	@Column(name = "cycle")
	private Integer cycle;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* newDeviceDetail
	*/
	@Column(name = "new_device_detail")
	private String newDeviceDetail;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* useraId
	*/
	@Column(name = "usera_id")
	private Integer useraId;
	/**
	* userbId
	*/
	@Column(name = "userb_id")
	private Integer userbId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
