package com.example.removetolocal.newentity.entity;

import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for user_log
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update user_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "user_log")
public class UserLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* content
	*/
	@Column(name = "content")
	private String content;
	/**
	* time
	*/
	@Column(name = "time")
	private Date time;
	/**
	* userId
	*/
	@Column(name = "user_id")
	private Integer userId;

}
