package com.example.removetolocal.newrepair.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.Data;
import javax.persistence.*;

import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for repair_back_bill
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "repair_back_bill")
public class RepairBackBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* backCheckDetail
	*/
	@Column(name = "back_check_detail")
	private String backCheckDetail;
	/**
	* backCheckResult
	*/
	@Column(name = "back_check_result")
	private String backCheckResult;
	/**
	* backReciveCheckDetail
	*/
	@Column(name = "back_recive_check_detail")
	private String backReciveCheckDetail;
	/**
	* backReciveCheckResult
	*/
	@Column(name = "back_recive_check_result")
	private String backReciveCheckResult;
	/**
	* backStatus
	*/
	@Column(name = "back_status")
	private Integer backStatus;
	/**
	* billFileName
	*/
	@Column(name = "bill_file_name")
	private String billFileName;
	/**
	* billFileUrl
	*/
	@Column(name = "bill_file_url")
	private String billFileUrl;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* deviceRepairBillId
	*/
	@Column(name = "device_repair_bill_id")
	private Integer deviceRepairBillId;
	/**
	* docNum
	*/
	@Column(name = "doc_num")
	private String docNum;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leftSignatureId
	*/
	@Column(name = "left_signature_id")
	private String leftSignatureId;
	/**
	* receiveCount
	*/
	@Column(name = "receive_count")
	private Integer receiveCount;
	/**
	* receiveFileName
	*/
	@Column(name = "receive_file_name")
	private String receiveFileName;
	/**
	* receiveFileUrl
	*/
	@Column(name = "receive_file_url")
	private String receiveFileUrl;
	/**
	* receiveTime
	*/
	@Column(name = "receive_time")
	private java.util.Date receiveTime;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* receiveUseraId
	*/
	@Column(name = "receive_usera_id")
	private Integer receiveUseraId;
	/**
	* receiveUserbId
	*/
	@Column(name = "receive_userb_id")
	private Integer receiveUserbId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* rightSignatureId
	*/
	@Column(name = "right_signature_id")
	private String rightSignatureId;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private java.util.Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendedCount
	*/
	@Column(name = "sended_count")
	private Integer sendedCount;
	/**
	* sendingCount
	*/
	@Column(name = "sending_count")
	private Integer sendingCount;
	/**
	* startUseraId
	*/
	@Column(name = "start_usera_id")
	private Integer startUseraId;
	/**
	* startUserbId
	*/
	@Column(name = "start_userb_id")
	private Integer startUserbId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* sendFiles
	*/
	@Column(name = "send_files")
	private String sendFiles;

	@Column(name = "old_id")
	private Integer oldId;

	public com.example.removetolocal.newentity.entity.RepairBackBill toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.RepairBackBill.class);
	}
}
