package com.example.removetolocal.newrepel.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description
 * @createTime 2021年01月10日 10:34:00
 */
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Table(name = "repel_device_unit")
public class RepelDeviceUnit {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Integer id;

    @Column(name = "device_id")
    private Integer deviceId;

    @Column(name = "units_id")
    private Integer unitsId;

    public RepelDeviceUnit(Integer deviceId, Integer unitsId) {
        this.deviceId = deviceId;
        this.unitsId = unitsId;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public  Integer getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getUnitsId() {
        return unitsId;
    }

    public void setUnitsId(Integer unitsId) {
        this.unitsId = unitsId;
    }

    public com.example.removetolocal.newentity.entity.RepelDeviceUnit toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.RepelDeviceUnit.class);
    }
}
