package com.example.removetolocal.service.impl;

import com.example.removetolocal.newallot.dao.AllotBillDao;
import com.example.removetolocal.newallot.entity.AllotBill;
import com.example.removetolocal.newback.dao.AllotBackBillDao;
import com.example.removetolocal.newback.entity.AllotBackBill;
import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.newstorage.entity.TaskLog;
import com.example.removetolocal.newuser.dao.UnitsDao;
import com.example.removetolocal.oldentity.DevAllot;
import com.example.removetolocal.oldentity.DevBack;
import com.example.removetolocal.oldentity.DevTasklog;
import com.example.removetolocal.oldentity.DevTaskmain;
import com.example.removetolocal.oldentity.dao.*;
import com.example.removetolocal.service.AllotService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class AllotServiceImpl implements AllotService {
    @Autowired
    AllotBillDao allotBillDao;
    @Autowired
    AllotBackBillDao allotBackBillDao;
    @Autowired
    DevAllotDao devAllotDao;
    @Autowired
    DevAllotDetailDao devAllotDetailDao;
    @Autowired
    DevBackDao devBackDao;
    @Autowired
    DevBackDetailDao devBackDetailDao;
    @Autowired
    UserService userService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    TaskLogDao taskLogDao;
    @Autowired
    UnitsDao unitsDao;
    /**
     * 配发业务转换
     */
    @Override
    public void moveAllot() {
        //转换配发单
        List<DevAllot> devAllots = devAllotDao.findAll();
        devAllots.forEach(devAllot -> {
            if (devAllot.getStatus()!=0&&devAllot.getStatus()!=-1&&unitsDao.findByOldId(devAllot.getHandleUnit())!=null){
                AllotBill allotBill = new AllotBill();
                if (devAllot.getSendUser()!=null) {
                    allotBill.setSendUseraId(userService.getUserByOldId(devAllot.getSendUser()).getUserId());
                }
                if (devAllot.getSendConfirmUser()!=null) {
                    allotBill.setSendUserbId(userService.getUserByOldId(devAllot.getSendConfirmUser()).getUserId());
                    allotBill.setAgent(userService.getUserByOldId(devAllot.getSendConfirmUser()).getName());
                }
                if (devAllot.getHandleUser()!=null) {
                    if (userService.getUserByOldId(devAllot.getHandleUser())!=null) {
                        allotBill.setReceiveUseraId(userService.getUserByOldId(devAllot.getHandleUser()).getUserId());
                    }
                }
                if (devAllot.getHandleConfirmUser()!=null) {
                    if (userService.getUserByOldId(devAllot.getHandleConfirmUser())!=null) {
                        allotBill.setReceiveUserbId(userService.getUserByOldId(devAllot.getHandleConfirmUser()).getUserId());
                    }
                }
                allotBill.setOldId(devAllot.getId());
                allotBill.setUpdateTime(devAllot.getUpdateTime());
                allotBill.setCreateTime(devAllot.getSendTime());
                allotBill.setCreateUserId(allotBill.getSendUseraId());
                allotBill.setUpdateTime(devAllot.getSendTime());
                if (devAllot.getUpdateUser()!=null) {
                    allotBill.setUpdateUserId(userService.getUserByOldId(devAllot.getUpdateUser()).getUserId());
                }
                else {
                    allotBill.setUpdateUserId(allotBill.getSendUseraId());
                }
                allotBill.setTitle(devAllot.getTitle());
                allotBill.setSendUnit(userService.getUnitNameByOldId(devAllot.getSendUnit()));
                allotBill.setSendTime(devAllot.getSendTime());
                allotBill.setReplayNumber(devAllot.getReplyDocNo());
                allotBill.setApplyNumber(devAllot.getApplyDocNo());
                allotBill.setReceiveUnit(userService.getUnitNameByOldId(devAllot.getHandleUnit()));
                allotBill.setReceiveTime(devAllot.getHandleTime());
                allotBill.setAllotCount(devAllot.getTotal());
                allotBill.setAllotedCount(devAllot.getTotal());
                allotBill.setReceiveCount(devAllot.getTotal());
                allotBill.setAllotCheckResult("0x0");
                allotBill.setReceiveCheckResult("0x0");
                allotBill.setNum(devAllot.getApplyDocNo());
                allotBill.setAllotType(2);
                allotBill.setAllotStatus(5);
                List<Integer> deviceIds = new ArrayList<>();
                devAllotDetailDao.findAllByAllotId(devAllot.getId()).forEach(devAllotDetail -> deviceIds.add(deviceLibraryDao.findByOldId(devAllotDetail.getDevId()).getId()));
                allotBill.setAllotCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                allotBill.setReceiveCheckDetail(allotBill.getAllotCheckDetail());
                AllotBill allotBill1 = allotBillDao.save(allotBill);
                //task转换
                DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(1,devAllot.getId());
                if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(allotBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    Task task = taskDao.save(taskBto.toDo());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
            }
        });
    }

    /**
     * 退回业务转换
     */
    @Override
    public void moveBack() {
        //转换退回单
        List<DevBack> devBacks = devBackDao.findAll();
        devBacks.forEach(devBack -> {
            if (devBack.getStatus()!=0&&devBack.getStatus()!=-1&&unitsDao.findByOldId(devBack.getHandleUnit())!=null){
                AllotBackBill allotBill = new AllotBackBill();
                if (devBack.getSendUser()!=null) {
                    allotBill.setSendUseraId(userService.getUserByOldId(devBack.getSendUser()).getUserId());
                }
                if (devBack.getSendConfirmUser()!=null) {
                    allotBill.setAgent(userService.getUserByOldId(devBack.getSendConfirmUser()).getName());
                }
                if (devBack.getHandleUser()!=null) {
                    if (userService.getUserByOldId(devBack.getHandleUser())!=null) {
                        allotBill.setReceiveUseraId(userService.getUserByOldId(devBack.getHandleUser()).getUserId());
                    }
                }
                if (devBack.getHandleConfirmUser()!=null) {
                    if (userService.getUserByOldId(devBack.getHandleConfirmUser())!=null) {
                        allotBill.setReceiveUserbId(userService.getUserByOldId(devBack.getHandleConfirmUser()).getUserId());
                    }
                }
                allotBill.setOldId(devBack.getId());
//                allotBill.setUpdateTime(devBack.getUpdateTime());
                allotBill.setCreateTime(devBack.getSendTime());
                allotBill.setCreateUserId(allotBill.getSendUseraId());
                allotBill.setUpdateTime(devBack.getSendTime());
//                if (devBack.getUpdateUser()!=null) {
//                    allotBill.setUpdateUserId(userService.getUserByOldId(devBack.getUpdateUser()).getUserId());
//                }
//                else {
                allotBill.setUpdateUserId(allotBill.getSendUseraId());
//                }
//                allotBill.setTitle(devBack.getTitle());
                allotBill.setSendUnit(userService.getUnitNameByOldId(devBack.getSendUnit()));
                allotBill.setSendTime(devBack.getSendTime());
                allotBill.setReplayNumber(devBack.getReplyDocNo());
                allotBill.setApplyNumber(devBack.getApplyDocNo());
                allotBill.setReceiveUnit(userService.getUnitNameByOldId(devBack.getHandleUnit()));
                allotBill.setReceiveTime(devBack.getHandleTime());
                allotBill.setBackCount(devBack.getTotal());
                allotBill.setBackedCount(devBack.getTotal());
                allotBill.setReceiveCount(devBack.getTotal());
                allotBill.setBackCheckResult("0x0");
                allotBill.setReceiveCheckResult("0x0");
                allotBill.setNum(devBack.getApplyDocNo());
//                allotBill.setAllotType(2);
                allotBill.setBackStatus(3);
                List<Integer> deviceIds = new ArrayList<>();
                devBackDetailDao.findAllByBackId(devBack.getId()).forEach(devBackdetail -> deviceIds.add(deviceLibraryDao.findByOldId(devBackdetail.getDevId()).getId()));
                allotBill.setBackCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                allotBill.setReceiveCheckDetail(allotBill.getBackCheckDetail());
                AllotBackBill allotBill1 = allotBackBillDao.save(allotBill);
                //task转换
                DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(7,devBack.getId());
                if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(allotBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    Task task = taskDao.save(taskBto.toDo());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
            }
        });
    }
}
