package com.example.removetolocal.service.impl;

import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.newstorage.entity.TaskLog;
import com.example.removetolocal.newtrain.dao.TrainThemeDao;
import com.example.removetolocal.newtrain.dao.TrainUserDao;
import com.example.removetolocal.newtrain.entity.TrainTheme;
import com.example.removetolocal.newtrain.entity.TrainUser;
import com.example.removetolocal.newuser.domin.Units;
import com.example.removetolocal.newuser.domin.User;
import com.example.removetolocal.oldentity.DevTasklog;
import com.example.removetolocal.oldentity.DevTaskmain;
import com.example.removetolocal.oldentity.dao.DevTasklogDao;
import com.example.removetolocal.oldentity.dao.DevTaskmainDao;
import com.example.removetolocal.oldentity.dao.DevTaskoperaterDao;
import com.example.removetolocal.oldtrain.DevTrainEnroll;
import com.example.removetolocal.oldtrain.dao.DevTrainDao;
import com.example.removetolocal.oldtrain.dao.DevTrainEnrollDao;
import com.example.removetolocal.service.TrainService;
import com.example.removetolocal.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zjm
 * @Description TODO
 * @Date 2020/12/25 下午3:39
 * @Version 1.0
 */
@Service
public class TrainServiceImpl implements TrainService {
    @Autowired
    TrainThemeDao trainThemeDao;
    @Autowired
    TrainUserDao trainUserDao;
    @Autowired
    DevTrainDao devTrainDao;
    @Autowired
    DevTrainEnrollDao devTrainEnrollDao;
    @Autowired
    UserService userService;

    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    DevTaskoperaterDao devTaskoperaterDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    TaskLogDao taskLogDao;

    /**
     * 只迁移已完成的状态 1.报名中 2.截止报名 3.结束 4.撤销',
     */
    @Override
    public void trainDcToNew() {
        devTrainDao.findAllByStatus(3).forEach(
                devTrain -> {
                  TrainTheme trainTheme=devTrain.toTrainTheme();
                  User user;
                  if (devTrain.getCreateuser()==null){
                      user= userService.getUserByOldId(devTrain.getUpdateuser());
                  }
                  else {
                      user = userService.getUserByOldId(devTrain.getCreateuser());
                  }
                  trainTheme.setOriginatorId(user.getUserId());
                  trainTheme.setOriginatorName(user.getName());
                  Units units= userService.getUnitByOldId(devTrain.getCreateOrg());
                  trainTheme.setUnitsId(units.getUnitId());
                  trainTheme.setUnitsName(devTrain.getHost());
                  trainTheme.setTrainStatus(9999);
                  TrainTheme trainTheme1= trainThemeDao.save(trainTheme);
                  trainUserDaoDcToNew(devTrain.getId(),trainTheme1.getTrainId());
                    toTask18(devTrain.getId(),trainTheme1.getTrainId());
                }
        );
    }

    private void toTask18(Integer id1, Integer id2){
        //task转换
        List<DevTaskmain> devTaskmains = devTaskmainDao.findAllByTypeAndResourceId(18,id1);
        DevTaskmain devTaskmain = devTaskmains.get(devTaskmains.size()-1);
        if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
            TaskBto taskBto = devTaskmain.parseToTaskBto();
            taskBto.setBillId(id2);
            taskBto.setOldId(devTaskmain.getId());
            Task task = taskDao.save(taskBto.toDo());
            //添加业务日志
            List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
            devTasklogs.forEach(devTasklog -> {
                TaskLog taskLog = new TaskLog();
                taskLog.setCreateTime(devTasklog.getOperateTime());
                taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                taskLog.setUpdateTime(taskLog.getCreateTime());
                taskLog.setUpdateUserId(taskLog.getCreateUserId());
                taskLog.setFileDetail("Ǵ");
                taskLog.setRemark(devTasklog.getNote());
                taskLog.setTaskId(task.getId());
                taskLog.setOldId(devTasklog.getId());
                taskLogDao.save(taskLog);
            });
        }
    }

    private void trainUserDaoDcToNew(Integer trainOldId,Integer newTrainId){
        List<DevTrainEnroll> allByTrainId = devTrainEnrollDao.findAllByTrainId(trainOldId);
        List<TrainUser> trainUsers=new ArrayList<>();
        allByTrainId.forEach(
//                状态:1.任务未读 2.已报名 3.忽略报名 4.参加考试 5.缺席考试
                devTrainEnroll -> {
                    TrainUser trainUser=new TrainUser();
                    trainUser.setTrainId(newTrainId);
                    User user=  userService.getUserByOldId(devTrainEnroll.getVmanagerId());
                    trainUser.setUserId(user.getUserId());
                    trainUser.setName(user.getName());
                    if (devTrainEnroll.getStatus()==1 ||devTrainEnroll.getStatus()==3){
                        trainUser.setAttendance("不参加培训");
                        trainUser.setIsSignUp(2);
                        trainUser.setCertificate(0);
                    }else if (devTrainEnroll.getStatus()==5){
                        trainUser.setAttendance("缺考");
                        trainUser.setIsSignUp(1);
                        trainUser.setCertificate(0);
                    }else {
                        trainUser.setAttendance("正常参加");
                        trainUser.setIsSignUp(1);
                        trainUser.setCertificate(1);
                        trainUser.setScore(String.valueOf(devTrainEnroll.getScore()));

                    }
                    trainUser.setIdCard(user.getIdCard());
                    trainUser.setMobile(user.getMobile());
                    trainUser.setPosition(user.getPosition());
                    trainUser.setSex(user.getSex());
                    Units units=userService.getUnitByOldId(devTrainEnroll.getOwnsup());
                    trainUser.setUnitsName(units.getName());
                    trainUser.setUnitsId(units.getUnitId());
                    trainUser.setIsNotJoinUserId(2);
                    trainUser.setEvaluation("");
                    trainUsers.add(trainUser);
                }
        );
        trainUserDao.saveAll(trainUsers);
    }
}
