package com.example.removetolocal.utils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 * @description 分隔组合字段工具栏
 */
public class StringSplitUtil {

    public static List<Integer> fileIdSplit(String s) {
        List<Integer> list = new ArrayList<>();
        if (s != null) {
            //按分隔符,分隔
            String[] strings = s.split(",");
            //遍历获取id
            if (strings.length != 0) {
                for (String str : strings) {
                    if (str.length() > 0) {
                        list.add(Integer.valueOf(str));
                    }
                }
            }
        }
        return list;
    }

    public static String idListToString(List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (list != null && list.size() > 0) {
            list.forEach(integer -> {
                stringBuffer.append(integer);
                stringBuffer.append("x");
            });
        }
        return stringBuffer.toString();
    }

    public static List<Integer> userIdSplit(String s) {
        List<Integer> list = new ArrayList<>();
        if (s != null) {
            //按分隔符x分隔
            String[] strings = s.split("x");
            //遍历获取id
            if (strings.length != 0) {
                for (String str : strings) {
                    if (str.length() > 0) {
                        if ("null".equals(str)){
                            list.add(-100);
                        }
                        else {
                            list.add(Integer.valueOf(str));
                        }
                    }
                }
            }
        }
        return list;
    }

    public static String idListToCheckString(List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (list != null && list.size() > 0) {
            list.forEach(integer -> {
                stringBuffer.append(integer);
                stringBuffer.append("1");
                stringBuffer.append("x");
            });
        }
        return stringBuffer.toString();
    }
}
