package com.zjty.automatedtesting.pojo.report;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * <p>Description : selenium-test
 * <p>Date : 2020/1/3 9:43
 * <p>@author : C
 */
@SuppressWarnings("JpaDataSourceORMInspection")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "AUTO_TEST_REPORT")
public class Report {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 测试用例标题
     */
    @ApiModelProperty(value = "测试用例标题", example = "百度一下", position = 1)
    private String title;

    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器", example = "firefox", position = 2)
    private String browser;

    /**
     * 网站地址
     */
    @ApiModelProperty(value = "网站地址", example = "http://www.baidu.com", position = 3)
    private String url;

    /**
     * 每个步骤结果详情
     */
    @Column(columnDefinition = "text")
    private String measures;

}
