package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.test.CaseVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface CaseService {

    /**
     * 保存测试用例
     * 不附带id为新增
     * 附带id为修改
     * @param caseVo testCaseVo
     * @return 保存的id
     */
    Integer save(CaseVo caseVo);

    /**
     * 指定id删除测试用例
     * @param id id
     */
    void delete(Integer id);

    /**
     * 查询所有测试用例
     * @return list
     */
    List<CaseVo> findAll();

    /**
     * 指定id查询测试用例
     * @param id id
     * @return testcase
     */
    CaseVo findById(Integer id);

}
