## 自动测试-数据库设计

### 引言

本文档旨在描述自动测试系统中的数据库结构与设计。面向参与开发、测试、维护之人。

### 数据库

#### 概述

- 数据库选取MySQL。
- 数据库名：automated_testing
- 字符集：utf8

- 本数据库中的所有表均以“AUTO_TEST_”为前缀，如测试用例表名称为AUTO_TEST_CASE。
- 所有表以int自增类型为主键。

- 在表字段中集合形式的数据以json格式字符串存储。在调用时数据会在程序中进行转换后提供，或进行转换后保存。

#### 表结构设计

测试用例

表名：AUTO_TEST_CASE

| 字段名  | 类型    | 长度 | 是否可null | 备注                                                         |
| ------- | ------- | ---- | ---------- | ------------------------------------------------------------ |
| id      | int     |      | 否         | 主键                                                         |
| title   | varchar | 255  | 是         | 标题                                                         |
| browser | varchar | 255  | 是         | 浏览器 Chrome、Firefox、IE                                   |
| url     | text    |      | 是         | 起始网站地址                                                 |
| steps   | text    |      | 是         | 各步骤详情，以json格式字符串形式存储。在程序中可以转换为集合类型。 |

测试报告

表名：AUTO_TEST_REPORT

| 字段名   | 类型    | 长度 | 是否可null | 备注                                                         |
| -------- | ------- | ---- | ---------- | ------------------------------------------------------------ |
| id       | int     |      | 否         | 主键                                                         |
| case_id  | int     |      | 是         | 所属测试用例的id                                             |
| title    | varchar | 255  | 是         | 标题                                                         |
| browser  | varchar | 255  | 是         | 浏览器 Chrome、Firefox、IE                                   |
| url      | text    |      | 是         | 起始网站地址                                                 |
| measures | text    |      | 是         | 各步骤结果详情，以json格式字符串形式存储。在程序中可以转换为集合类型。 |

