package com.zjty.automatedtesting.pojo.report;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * <p>Description : selenium-test
 * <p>Date : 2020/1/3 9:43
 * <p>@author : C
 */
@SuppressWarnings("JpaDataSourceORMInspection")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "AUTO_TEST_REPORT")
public class Report {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 所属的测试用例id.指明由该报告是哪个测试用例执行后生成的.
     */
    private Integer caseId;

    /**
     * 测试用例标题
     */
    private String title;

    /**
     * 浏览器
     */
    private String browser;

    /**
     * 网站地址
     */
    @Column(columnDefinition = "text")
    private String url;

    /**
     * 每个步骤结果详情
     */
    @Column(columnDefinition = "text")
    private String measures;

}
