package com.zjty.automatedtesting.pojo.test;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;


/**
 * <p>Description : assess
 * <p>Date : 2020/1/3 17:04
 * <p>@author : C
 */
@SuppressWarnings("JpaDataSourceORMInspection")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "AUTO_TEST_CASE")
public class Case {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 所属测试系统id
     */
    private String systemId;

    /**
     * 标题
     */
    private String title;

    /**
     * 浏览器
     */
    private String browser;

    /**
     * 运行环境
     */
    private String environment;

    /**
     * 起始网站
     */
    @Column(columnDefinition = "text")
    private String url;

    /**
     * 步骤详情
     */
    @Column(columnDefinition = "text")
    private String steps;

}
