package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.test.CaseVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface CaseService {

    /**
     * 新增测试用例
     * 不可附带id
     * @param caseVo testCaseVo
     * @return 保存的id
     */
    Integer create(CaseVo caseVo);

    /**
     * 保存测试用例
     * 必须附带id
     * @param caseVo testCaseVo
     * @return 保存的id
     */
    Integer update(CaseVo caseVo);

    /**
     * 指定id删除测试用例
     * @param id id
     */
    void delete(Integer id);

    /**
     * 查询所有测试用例
     * @return 测试用例集合
     */
    List<CaseVo> findAll();

    /**
     * 查询指定测试系统下的所有测试用例
     * @return 测试用例集合
     */
    List<CaseVo> findBySystemId(String systemId);

    /**
     * 指定id查询测试用例
     * @param id id
     * @return 测试用例
     */
    CaseVo findById(Integer id);

}
