package com.zjty.automatedtesting.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    /* 公共的 */
    public final static String CHROME_EXE = System.getProperty("user.dir")+"\\chromedriver.exe";

    public final static String FIRE_FOX_EXE = System.getProperty("user.dir")+"\\geckodriver.exe";

    public final static String IE_EXE = System.getProperty("user.dir")+"\\IEDriverServer.exe";


    /**
     * 结束所有残留进程
     * @param
     */
    public static void killSelenium(){
        String[] pss = new String[]{
                "chromedriver*",// google驱动
                "IEDriver*",// IE 驱动
                "geckodriver*",// Firefox 驱动
                "operadriver*"// opera 驱动
        };
        for(String p1:pss){
            kill_process(p1);
        }
    }

    /**
     * 结束残留进程
     * @param s
     */
    public static void kill_process(String s){
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("taskkill /f /t /im "+s);
        } catch (Exception e) {
            logger.error("结束进程失败！进程名："+s+""+ e.getMessage(),e );
        }
    }

    /**
     * 获取当前日期和时间
     * @return
     */
    public static String getNowDateTimeByFormat(String formatString) {
        if( null==formatString ){
            formatString = "yyyy-MM-dd HH:mm:ss";
        }
        return new SimpleDateFormat(formatString).format(new Date());
    }
}
