package com.zjty.automatedtesting.util;


import com.zjty.automatedtesting.pojo.report.Measure;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import com.zjty.automatedtesting.pojo.test.Case;
import lombok.extern.slf4j.Slf4j;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

import static java.util.Objects.isNull;

/**
 * <p>Description : measurement
 * <p>Date : 2020/1/16 15:27
 * <p>@author : C
 */
@Slf4j
public class FileUtil {

    private final static String WORK_PATH = System.getProperty("user.dir") + "\\";

    private final static String REPORT_HTML_TEMP_FIRST_PART = "<html>\n" +
            "<head>\n" +
            "<style>\n" +
            ".table15_12 table {\n" +
            "\twidth:100%;\n" +
            "\tmargin:15px 0;\n" +
            "\tborder:0;\n" +
            "}\n" +
            ".table15_12 th {\n" +
            "\tfont-weight:bold;\n" +
            "\tbackground-color:#d8f1fe;\n" +
            "\tcolor:#20a0fe\n" +
            "}\n" +
            ".table15_12,.table15_12 th,.table15_12 td {\n" +
            "\tfont-size:0.95em;\n" +
            "\ttext-align:center;\n" +
            "\tpadding:4px;\n" +
            "\tborder-collapse:collapse;\n" +
            "}\n" +
            ".table15_12 th {\n" +
            "\tborder: 1px solid #d8f1fe;\n" +
            "\tborder-width:1px\n" +
            "}\n" +
            ".table15_12 td {\n" +
            "\tborder: 1px solid #d8f1fe;\n" +
            "\tborder-width:1px\n" +
            "}\n" +
            ".table15_12 tr {\n" +
            "\tborder: 1px solid #ffffff;\n" +
            "}\n" +
            ".table15_12 tr:nth-child(odd){\n" +
            "\tbackground-color:#f7f7f7;\n" +
            "}\n" +
            ".table15_12 tr:nth-child(even){\n" +
            "\tbackground-color:#ffffff;\n" +
            "}\n" +
            "</style>\n" +
            "</head>\n" +
            "<body>\n" +
            "<div>ID:#{id}</div>\n" +
            "<div>标题:#{title}</div>\n" +
            "<div>浏览器:#{browser}</div>\n" +
            "<div>地址:#{url}</div>\n" +
            "\n" +
            "<br/>\n" +
            "<div>测试步骤详情</div>\n" +
            "<table class=table15_12>\n" +
            "<tr>\n" +
            "\t<th>编号</th>\n" +
            "\t<th>步骤名</th>\n" +
            "\t<th>预期值</th>\n" +
            "\t<th>实际值</th>\n" +
            "\t<th>结果</th>\n" +
            "\t<th>相关信息</th>\n" +
            "</tr>\n";

    private final static String REPORT_HTML_TEMP_LAST_PART = "\n" +
            "</table>\n" +
            "\n" +
            "</body>\n" +
            "\n" +
            "</html>";

    private Case parseFileToTestCase(String fileName) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(WORK_PATH + fileName));
        StringBuilder builder = new StringBuilder();
        lines.forEach(builder::append);
        String data = builder.toString();
        return JsonUtil.readValue(data, Case.class);
    }

    public static String getRepotHtmlContent(ReportVo reportVo) {
        StringBuilder content = new StringBuilder();
        String first_part = REPORT_HTML_TEMP_FIRST_PART
                .replace("#{id}", reportVo.getId().toString())
                .replace("#{title}", reportVo.getTitle())
                .replace("#{browser}", reportVo.getBrowser())
                .replace("#{url}", reportVo.getUrl());
        content.append(first_part);
        String rowTemp = "<tr>\n" +
                "\t<td>#{order}</td>\n" +
                "\t<td>#{title}</td>\n" +
                "\t<td>#{success}</td>\n" +
                "\t<td>#{message}</td>\n" +
                "</tr>\n";
        List<Measure> measures = reportVo.getMeasures();
        for (Measure measure : measures) {
            String row = rowTemp
                    .replace("#{order}", isNull(measure.getOrder()) ? "" : measure.getOrder().toString())
                    .replace("#{title}", isNull(measure.getTitle()) ? "" : measure.getTitle())
                    .replace("#{success}", measure.getSuccess() ? "成功" : "失败")
                    .replace("#{message}", measure.getMessage());
            content.append(row);
        }
        content.append(REPORT_HTML_TEMP_LAST_PART);

        return content.toString();
    }

    public static void output(String text, OutputStream os) {
        byte[] buffer = new byte[1024];
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
            bis = new BufferedInputStream(is);
            int i = bis.read(buffer);
            while (i != -1) {
                os.write(buffer, 0, i);
                i = bis.read(buffer);
            }
        } catch (Exception e) {
            log.error("error:" + e);
        } finally {
            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }

}
