## 自动测试-详细设计

### 概述

自动测试模块是一个独立的微服务。

它的作用是对于特定的系统，在特定的运行环境下（包括操作系统、浏览器版本）是否可以正常运作进行自动测试并给出测试结果。

最核心功能，可以概括为3步：

- 事先写好测试用例
- 由程序来执行测试用例
- 输出测试报告

### 总体设计

使用Spring Boot框架。

使用MySQL作为数据库，存储测试用例数据与测试报告数据。

以restful接口形式对外提供其功能，数据格式采用json格式。

其优点可以概括为以下2点：

- 运行环境已经由软件提供方配好，用户可以直接使用。
- 只要配置好测试用例后，一键便可执行整套测试用例完成对系统的测试。

### 功能设计

#### 测试系统

![总览](D:\Documents\黄承天-工作文件\总览.png)

总览

##### 新建测试系统

需要输入系统名，创建后默认打开刚创建的测试系统。系统名和编码在页面右上方显示。

![创建测试系统](D:\Documents\黄承天-工作文件\创建测试系统.png)

##### 打开测试系统

需要输入测试系统编码。打开成功后系统名和编码在页面右上方显示。

打开测试系统后可在页面中配置管理该系统的测试用例，也可以一键执行测试用例。

![打开测试系统](D:\Documents\黄承天-工作文件\打开测试系统.png)

#### 测试用例

包含一系列自动化的浏览器操作，也就是描述了一个测试过程的数据。一个测试系统下可以有多个测试用例。

##### 添加测试用例

需要填写标题、地址、运行环境并选择浏览器，然后添加测试步骤，最后保存。

![测试用例](D:\Documents\黄承天-工作文件\测试用例.png)

##### 修改测试用例

与添加测试用例相同。

##### 删除测试用例

删除选中的单个测试用例。

#### 测试步骤

步骤指示了单个的浏览器操作，可以是对某个指定元素的操作，也可以是前进返回之类的无元素操作。在测试用例的编辑窗口中可以对测试步骤进行操作。

##### 添加测试步骤

需要填写标题、操作类型，额外的填写内容视操作类型而不同。可添加或删除断言。

操作类型：有以下4种

- input：对输入框输入文字的操作，需要填写元素的定位方式、定位关键值、输入值。

- click：对按钮的点击操作，需要填写元素的定位方式、定位关键值。
- select：下拉框选择，需要填写元素的定位方式、定位关键值、输入值。

- switch：切换至指定的内置框，需要填写元素的定位方式、定位关键值。

- home：回到起始地址，不需要填写其它值。

另外，元素的定位方式有4种：xpath、id、class、css。其中xpath最为好用且常用。

![测试步骤编辑](D:\Documents\黄承天-工作文件\测试步骤编辑.png)

断言：用于判断操作执行后，页面中某个指定元素的情况是否和预期的一致。断言可以有多个，可添加或删除断言。

添加断言时同样需要填写元素定位方式与定位关键值，为了找到指定的元素。此外还需要填写断言类型。

断言类型有4种：equals、not_equals、exist、not_exist。

其中equals和not_equals需要再填写断言键和断言值，判断实际值与断言值是否相等，或者不相等。

而exist和not_exist仅仅是判断指定的元素是否存在，不需要断言键与值。

![断言编辑](D:\Documents\黄承天-工作文件\断言编辑.png)

##### 编辑测试步骤

与添加步骤相同，区别在于修改已存在的测试步骤。

##### 删除测试步骤

删除选中的单个测试步骤。

#### 测试报告

由测试用例执行后生成，内容包括测试用例的基本信息以及每个步骤的标题、是否成功的结果、相关信息。每个测试用例所生成的测试报告会被归在这个测试用例下。点击一个测试用例后会显示其具体信息，同时它所产生的测试报告会显示在右边列表中。

##### 查看测试报告

在测试用例执行完毕时，会弹出该次执行所产生的测试报告的详细信息。也可以在列表中点击对应的查看按钮来查看其详细信息。

测试报告会展示该测试用例的标题、地址、运行环境和浏览器，并且会显示每个步骤的序号、标题、结果（是否通过）、相关信息。

![测试报告](D:\Documents\黄承天-工作文件\测试报告.png)

##### 删除测试报告

删除选中的单个测试报告。

##### 下载测试报告

将测试报告以html文件的形式提供下载。

### 使用技术

#### MySQL

MySQL是一种关系型数据库管理系统，关系数据库将数据保存在不同的表中，而不是将所有数据放在一个大仓库

内，这样就增加了速度并提高了灵活性。也是现今常用的一种数据库了。

#### Selenium

Selenium是一个用于Web应用程序测试的工具。

Selenium测试直接运行在浏览器中，就像真正的用户在操作一样。

支持的浏览器包括IE，Firefox，Safari，Google Chrome，Opera等。

这个工具的主要功能包括：

测试与浏览器的兼容性——测试你的应用程序看是否能够很好得工作在不同浏览器和操作系统之上。

测试系统功能——创建回归测试检验软件功能和用户需求。

这是本项目实现自动测试的核心组件。在运行时需要与浏览器版本对应的驱动程序（否则会出错），放在项目同目录下即可。

##### 驱动程序下载地址

Firefox浏览器驱动：[geckodriver](https://github.com/mozilla/geckodriver/releases)
Chrome浏览器驱动：[chromedriver](https://sites.google.com/a/chromium.org/chromedriver/home)   [taobao备用地址](https://npm.taobao.org/mirrors/chromedriver)
IE浏览器驱动：[IEDriverServer](http://selenium-release.storage.googleapis.com/index.html)
Edge浏览器驱动：[MicrosoftWebDriver](https://developer.microsoft.com/en-us/microsoft-edge/tools/webdriver/)
Opera浏览器驱动：[operadriver](https://github.com/operasoftware/operachromiumdriver/releases)
PhantomJS浏览器驱动：[phantomjs](http://phantomjs.org/)

##### 驱动程序与浏览器版本关系

**Chrome**

| chromedriver版本 | 支持的Chrome版本 |
| ---------------- | ---------------- |
| v2.46            | v71-73           |
| v2.45            | v70-72           |
| v2.44            | v69-71           |
| v2.43            | v69-71           |
| v2.42            | v68-70           |
| v2.41            | v67-69           |
| v2.40            | v66-68           |
| v2.39            | v66-68           |
| v2.38            | v65-67           |
| v2.37            | v64-66           |
| v2.36            | v63-65           |
| v2.35            | v62-64           |
| v2.34            | v61-63           |
| v2.33            | v60-62           |
| v2.32            | v59-61           |

**FireFox***

具体在其下载页面查看。在各个版本的说明中会提及其对应的浏览器版本。

例如：0.26.0版本在其第一行说明中提及：

```
Note that with this release the minimum recommended Firefox version
has changed to Firefox ≥60.
```

要求FireFox版本大于60。

地址：[点此打开](https://github.com/mozilla/geckodriver/releases)

**IE**

IE浏览器的版本对应这个并没有找到具体所对应的版本，**一般用2.5版本**比较好一些（ie11）。

### 元素定位方法

假如我们有一个Web页面，通过前端工具（如，Firebug）查看到一个元素的属性是这样的。

```html
<html>
  <head>
  <body link="#0000cc">
    <a id="result_logo" href="/" οnmοusedοwn="return c({'fm':'tab','tab':'logo'})">
    <form id="form" class="fm" name="f" action="/s">
      <span class="soutu-btn"></span>
        <input id="kw" class="s_ipt" name="wd" value="" maxlength="255" autocomplete="off">
```

我们的目的是要定位input标签的输入框。

- 通过id定位：

  ```java
  driver.findElement(By.id("kw"))
  ```

- 通过name定位：

  ```java
  driver.findElement(By.name("wd"))
  ```

- 通过class name定位：

  ```java
  driver.findElement(By.className("s_ipt"))
  ```

- 通过tag name定位：

  ```java
  driver.findElement(By.tagName("input"))
  ```

- 通过xpath定位，xpath定位有N种写法，这里列几个常用写法：

  ```java
  driver.findElement(By.xpath("//*[@id='kw']"))
  driver.findElement(By.xpath("//*[@name='wd']"))
  driver.findElement(By.xpath("//input[@class='s_ipt']"))
  driver.findElement(By.xpath("/html/body/form/span/input"))
  driver.findElement(By.xpath("//span[@class='soutu-btn']/input"))
  driver.findElement(By.xpath("//form[@id='form']/span/input"))
  driver.findElement(By.xpath("//input[@id='kw' and @name='wd']"))
  ```

- 通过css定位，css定位有N种写法，这里列几个常用写法：

  ```java
  driver.findElement(By.cssSelector("#kw")
  driver.findElement(By.cssSelector("[name=wd]")
  driver.findElement(By.cssSelector(".s_ipt")
  driver.findElement(By.cssSelector("html > body > form > span > input")
  driver.findElement(By.cssSelector("span.soutu-btn> input#kw")
  driver.findElement(By.cssSelector("form#form > span > input")
  ```

接下来，我们的页面上有一组文本链接。

```java
<a class="mnav" href="http://news.baidu.com" name="tj_trnews">新闻</a>
<a class="mnav" href="http://www.hao123.com" name="tj_trhao123">hao123</a>
```

- 通过link text定位：

  ```java
  driver.findElement(By.linkText("新闻")
  driver.findElement(By.linkText("hao123")
  ```

- 通过partialLink text定位：

  ```java
  driver.findElement(By.partialLinkText("新")
  driver.findElement(By.partialLinkText("hao")
  driver.findElement(By.partialLinkText("123")
  ```

关于xpaht和css的定位比较复杂，请参考：[ xpath语法](http://www.w3school.com.cn/xpath/xpath_syntax.asp)、[css选择器](http://www.w3school.com.cn/cssref/css_selectors.asp)

### 相关接口概览

测试用例：

| url                   | 类型   | 描述                                        |
| --------------------- | ------ | ------------------------------------------- |
| /testcase/execute     | POST   | 执行测试用例                                |
| /testcase/save        | POST   | 保存测试用例（不附带id为新增 附带id为修改） |
| /testcase/get         | GET    | 获取所有测试用例                            |
| /testcase/get/{id}    | GET    | 根据id获取单个测试用例                      |
| /testcase/delete/{id} | DELETE | 根据id删除单个测试用例                      |

测试报告：

| url                       | 类型   | 描述                                                         |
| ------------------------- | ------ | ------------------------------------------------------------ |
| /report/get               | GET    | 获取所有测试报告                                             |
| /report/get/case/{caseId} | GET    | 根据所属测试用例的id查询测试报告.返回由该测试用例执行后生成的所有报告. |
| /report/get/{id}          | GET    | 根据id获取单个测试报告                                       |
| /report/delete/{id}       | DELETE | 根据id删除单个测试报告                                       |
| /report/download/{id}     | GET    | 根据id下载测试报告                                           |

详细可在swagger页面中查看和使用

### 更新记录

- 2020.2.10：最初的用selenium组件简单实现了自动化测试，并定义好了最初的测试用例和测试报告数据结构。此时只有一个执行测试用例接口。
- 2020.2.12：考虑到需要对测试用例的存储以及管理，使用spring-data-jpa接入MySQL数据库，并增加测试用例数据的增、改、删、查的接口。
- 2020.2.14：测试用例增加标题字段。测试步骤的操作类型增加switch（切换至指定的元素）和home（回到起始页面），由2种增加至4种。
- 2020.2.17：增加测试报告的数据库存储功能。在测试用例执行后自动将测试报告存至数据库。增加测试报告的查、删接口。
- 2020.2.20：增加下载测试报告的功能。以html文件的形式提供下载。
- 2020.2.24：测试用例执行结束后自动关闭浏览器。增加接口根据测试用例的id查询其所属的测试报告。预期属性改变为可选项，若没有预期属性则会低限度的以是否出现异常来判断步骤是否成功。
- 2020.2.25：修复Chrome驱动无法运行的问题。判断预期结果前和每个步骤执行后会等待2秒以保证结果更精准。
- 2020.2.28：完成测试系统这一块相关功能接口：增加测试系统的新增和查询接口；增加根据测试系统id查询测试用例的接口；增加根据测试系统id批量执行其所有测试用例的接口。
- 2020.3.2：数据结构改动：测试步骤的断言改为集合形式 ；并重新定义了断言的数据结构和判断机制。

### 遗留问题

- 该项目本身所依赖的运行环境并非国产化环境，例如数据库是使用非国产数据库的MySQL。

