package com.zjty.automatedtesting.controller;

import com.google.common.collect.ImmutableMap;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import com.zjty.automatedtesting.service.ReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@RequestMapping("/report")
@RestController
@Api(tags = "测试报告")
@CrossOrigin
public class ReportController {

    @Autowired
    ReportService reportService;

    @ApiOperation(value = "获取全部测试报告.")
    @GetMapping(value="/get")
    public ResponseEntity<List<ReportVo>> get(){
        return ResponseEntity.ok(reportService.findAll());
    }

    @ApiOperation(value = "按分页获取测试报告.页码从0开始.")
    @GetMapping(value="/get/page/{page}")
    public ResponseEntity<List<ReportVo>> get(@PathVariable Integer page){
        return ResponseEntity.ok(reportService.findByPage(page));
    }

    @ApiOperation(value = "获取单个测试报告.")
    @GetMapping(value="/get/{id}")
    public ResponseEntity<ReportVo> getById(@PathVariable Integer id){
        return ResponseEntity.ok(reportService.findById(id));
    }

    @ApiOperation(value = "删除测试报告.")
    @DeleteMapping(value="/delete/{id}")
    public ResponseEntity<Map<String,String>> findTestText(@PathVariable Integer id){
        reportService.delete(id);
        return ResponseEntity.ok(ImmutableMap.of("message","success"));
    }

}
