package com.zjty.automatedtesting.controller;

import com.google.common.collect.ImmutableMap;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import com.zjty.automatedtesting.pojo.test.CaseVo;
import com.zjty.automatedtesting.service.SeleniumService;
import com.zjty.automatedtesting.service.CaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author C
 */
@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@RequestMapping("/testcase")
@RestController
@Api(tags = "测试用例")
@CrossOrigin
public class TestCaseController {

    @Autowired
    SeleniumService seleniumService;

    @Autowired
    CaseService caseService;

    @ApiOperation(value = "提供测试用例数据.执行测试并返回测试结果报告.")
    @PostMapping(value="/execute")
    public ResponseEntity<ReportVo> execute(@RequestBody CaseVo caseVo){
        ReportVo execute = seleniumService.execute(caseVo);
        return ResponseEntity.ok(execute);
    }

    @ApiOperation(value = "保存测试用例.",notes = "不附带id为新增 附带id为修改")
    @PostMapping(value="/save")
    public ResponseEntity<Map<String,String>> save(@RequestBody CaseVo caseVo){
        caseService.save(caseVo);
        return ResponseEntity.ok(ImmutableMap.of("message","success"));
    }

    @ApiOperation(value = "删除测试用例.")
    @DeleteMapping(value="/delete/{id}")
    public ResponseEntity<Map<String,String>> findTestText(@PathVariable Integer id){
        caseService.delete(id);
        return ResponseEntity.ok(ImmutableMap.of("message","success"));
    }

    @ApiOperation(value = "获取全部测试用例.")
    @GetMapping(value="/get")
    public ResponseEntity<List<CaseVo>> get(){
        return ResponseEntity.ok(caseService.findAll());
    }

    @ApiOperation(value = "获取单个测试用例.")
    @GetMapping(value="/get/{id}")
    public ResponseEntity<CaseVo> getById(@PathVariable Integer id){
        return ResponseEntity.ok(caseService.findById(id));
    }



}
