package com.zjty.automatedtesting.pojo.report;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>Description : measurement
 * <p>Date : 2020/1/16 13:39
 * <p>@author : C
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试步骤结果")
public class Measure {


    /**
     * 步骤序号
     */
    @ApiModelProperty(value = "步骤序号",example = "1",position = 1)
    private Integer order;

    /**
     * 步骤名
     */
    @ApiModelProperty(value = "步骤名",example = "输入关键字",position = 2)
    private String title;

    /**
     * 是否成功
     */
    @ApiModelProperty(value = "是否成功",example = "true",position = 3)
    private Boolean success;

    /**
     * 判断类型
     */
    @ApiModelProperty(value = "判断类型",example = "value",notes = "目前有2种:value-当前元素的值 title-页面标题",position = 4)
    private String assertion;

    /**
     * 期望结果
     */
    @ApiModelProperty(value = "期望结果",example = "ty",position = 5)
    @JSONField(ordinal = 5)
    private String expected;

    /**
     * 实际结果
     */
    @ApiModelProperty(value = "实际结果",example = "ty",position = 6)
    private String practice;

    /**
     * 信息
     */
    @ApiModelProperty(value = "相关信息",example = "成功.",position = 7)
    private String message;

}
