package com.zjty.automatedtesting.pojo.test;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试用例")
public class CaseVo {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键id",example = "1")
    Integer id;

    /**
     * 测试用例标题
     */
    @ApiModelProperty(value = "测试用例标题",example = "百度一下",position = 1)
    String title;

    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器",example = "firefox",position = 2)
    String browser;

    /**
     * 起始网站
     */
    @ApiModelProperty(value = "网站地址",example = "http://www.baidu.com",position = 3)
    String url;

    /**
     * 步骤详情
     */
    @ApiModelProperty(value = "步骤详情",position = 4)
    List<Step> steps;

}
