package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.report.ReportVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface ReportService {

    /**
     * 保存 测试报告
     *
     * @return 保存的id
     */
    Integer save(ReportVo reportVo);

    /**
     * 查询所有
     *
     * @return 集合形式的测试报告
     */
    List<ReportVo> findAll();

    /**
     * 按分页查询
     * 每页10个
     * @param page 页码 从0开始
     * @return 集合形式的测试报告
     */
    List<ReportVo> findByPage(Integer page);

    /**
     * 按id查询单个
     *
     * @param id 指定id
     * @return 单个测试报告
     * 报告
     */
    ReportVo findById(Integer id);

    /**
     * 指定id删除
     *
     * @param id 指定的id
     */
    void delete(Integer id);

}
