package com.zjty.automatedtesting.service;

import com.alibaba.fastjson.JSON;
import com.zjty.automatedtesting.pojo.report.Measure;
import com.zjty.automatedtesting.pojo.report.Report;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import com.zjty.automatedtesting.pojo.test.Step;
import com.zjty.automatedtesting.pojo.test.Case;
import com.zjty.automatedtesting.pojo.test.CaseVo;
import com.zjty.automatedtesting.util.JsonUtil;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TransHelper {

    public Case toTestCase(CaseVo caseVo){
        String steps = JsonUtil.toJSon(caseVo.getSteps());
        return new Case(
                caseVo.getId(),
                caseVo.getTitle(),
                caseVo.getBrowser(),
                caseVo.getUrl(),
                steps
        );
    }

    public CaseVo toTestCaseVo(Case aCase){
        List<Step> steps = JsonUtil.readValueToList(aCase.getSteps(),Step.class);
        return new CaseVo(
                aCase.getId(),
                aCase.getTitle(),
                aCase.getBrowser(),
                aCase.getUrl(),
                steps
        );
    }

    public Report toReport(ReportVo reportVo){
        String measures = JsonUtil.toJSon(reportVo.getMeasures());
        return new Report(
                reportVo.getId(),
                reportVo.getTitle(),
                reportVo.getBrowser(),
                reportVo.getUrl(),
                measures
        );
    }

    public ReportVo toReportVo(Report report){
        List<Measure> measures = JSON.parseArray(report.getMeasures(), Measure.class);
        return new ReportVo(
                report.getId(),
                report.getTitle(),
                report.getBrowser(),
                report.getUrl(),
                measures
        );
    }
}
