package com.zjty.automatedtesting.pojo.test;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试用例")
public class CaseVo {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键id",example = "1")
    private Integer id;

    /**
     * 所属测试系统id
     */
    @ApiModelProperty(value = "所属测试系统id",example = "40285a81",position = 1)
    private String systemId;

    /**
     * 测试用例标题
     */
    @ApiModelProperty(value = "测试用例标题",example = "百度一下",position = 2)
    private String title;

    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器",example = "firefox",position = 3)
    private String browser;

    /**
     * 运行环境
     */
    @ApiModelProperty(value = "运行环境",example = "对运行环境的一些描述内容 Win 10/火狐版本 52.0/...",position = 4)
    private String environment;

    /**
     * 起始网站
     */
    @ApiModelProperty(value = "网站地址",example = "http://www.baidu.com",position = 5)
    private String url;

    /**
     * 步骤详情
     */
    @ApiModelProperty(value = "步骤详情",position = 6)
    private List<Step> steps;

}
