package com.zjty.automatedtesting.service.impl;

import com.alibaba.fastjson.JSON;
import com.zjty.automatedtesting.pojo.report.Measure;
import com.zjty.automatedtesting.pojo.report.Report;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import com.zjty.automatedtesting.pojo.test.*;
import com.zjty.automatedtesting.pojo.test.System;
import com.zjty.automatedtesting.service.CaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@Service
public class TransHelper {

    @Autowired
    CaseService caseService;


    public Case toTestCase(CaseVo caseVo) {
        String steps = JSON.toJSONString(caseVo.getSteps());
        return new Case(
                caseVo.getId(),
                caseVo.getSystemId(),
                caseVo.getTitle(),
                caseVo.getBrowser(),
                caseVo.getEnvironment(),
                caseVo.getUrl(),
                steps
        );
    }

    public CaseVo toTestCaseVo(Case aCase) {
        List<Step> steps = JSON.parseArray(aCase.getSteps(), Step.class);
        return new CaseVo(
                aCase.getId(),
                aCase.getSystemId(),
                aCase.getTitle(),
                aCase.getBrowser(),
                aCase.getEnvironment(),
                aCase.getUrl(),
                steps
        );
    }

    public ReportVo toReportVo(Report report) {
        List<Measure> measures = JSON.parseArray(report.getMeasures(), Measure.class);
        return new ReportVo(
                report.getId(),
                report.getTitle(),
                report.getBrowser(),
                report.getUrl(),
                measures
        );
    }

    public SystemVo toSystemVo(System system){
        List<CaseVo> cases = caseService.findBySystemId(system.getId());
        return new SystemVo(
                system.getId(),
                system.getName(),
                cases
        );
    }

}
