package com.zjty.automatedtesting.controller;

import com.google.common.collect.ImmutableMap;
import com.zjty.automatedtesting.pojo.report.Report;
import com.zjty.automatedtesting.pojo.test.TestCaseVo;
import com.zjty.automatedtesting.service.SeleniumService;
import com.zjty.automatedtesting.service.TestCaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author C
 */
@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@RequestMapping("/testcase")
@RestController
@Api(value = "自动化测试管理接口")
public class TestCaseController {

    @Autowired
    SeleniumService seleniumService;

    @Autowired
    TestCaseService testCaseService;

    @CrossOrigin
    @ApiOperation(value = "提供测试用例数据.执行测试并返回测试结果报告.")
    @PostMapping(value="/execute")
    public ResponseEntity<Report> execute(@RequestBody TestCaseVo testCaseVo){
        Report execute = seleniumService.execute(testCaseVo);
        return ResponseEntity.ok(execute);
    }

    @CrossOrigin
    @ApiOperation(value = "保存测试用例.",notes = "不附带id为新增 附带id为修改")
    @PostMapping(value="/save")
    public ResponseEntity<Map<String,String>> save(@RequestBody TestCaseVo testCaseVo){
        testCaseService.save(testCaseVo);
        return ResponseEntity.ok(ImmutableMap.of("message","success"));
    }

    @CrossOrigin
    @ApiOperation(value = "删除测试用例.")
    @DeleteMapping(value="/delete/{id}")
    public ResponseEntity<Map<String,String>> findTestText(@PathVariable Integer id){
        testCaseService.delete(id);
        return ResponseEntity.ok(ImmutableMap.of("message","success"));
    }

    @CrossOrigin
    @ApiOperation(value = "获取全部测试用例.")
    @GetMapping(value="/get")
    public ResponseEntity<List<TestCaseVo>> get(){
        return ResponseEntity.ok(testCaseService.findAll());
    }

    @CrossOrigin
    @ApiOperation(value = "获取单个测试用例.")
    @GetMapping(value="/get/{id}")
    public ResponseEntity<TestCaseVo> getById(@PathVariable Integer id){
        return ResponseEntity.ok(testCaseService.findById(id));
    }



}
