package com.zjty.automatedtesting.pojo.report;

import com.zjty.automatedtesting.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <p>Description : selenium-test
 * <p>Date : 2020/1/3 9:43
 * <p>@author : C
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试报告结果")
public class Report {

    /**
     * url
     */

    @ApiModelProperty(value = "网站地址",example = "http://www.baidu.com")
    private String url;

    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器",example = "firefox")
    private String explorer;

    /**
     * 每个步骤结果详情
     */
    @ApiModelProperty(value = "每个步骤结果详情")
    private List<Measure> measures;

}
