package com.zjty.automatedtesting.pojo.test;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.zjty.automatedtesting.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * <p>Description : selenium-test
 * <p>Date : 2020/1/3 9:47
 * <p>@author : C
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试用例步骤")
public class Step {



    /**
     * 步骤序号
     */
    @ApiModelProperty(value = "序号",example = "1")
    @JSONField(ordinal = 1)
    private Integer order;

    /**
     * 标题
     */
    @ApiModelProperty(value = "步骤的标题",example = "输入关键字")
    @JSONField(ordinal = 2)
    private String title;

    /**
     * 元素的定位类型
     */
    @ApiModelProperty(value = "元素的定位类型",example = "id")
    @JSONField(ordinal = 3)
    private String type;

    /**
     * 元素的定位关键值
     */
    @ApiModelProperty(value = "元素的定位关键值",example = "kw")
    @JSONField(ordinal = 4)
    private String key;

    /**
     * 元素的操作方式
     */
    @ApiModelProperty(value = "元素的操作方式",example = "input",notes = "目前有2种:input-输入 click-点击")
    @JSONField(ordinal = 5)
    private String action;

    /**
     * 输入值 操作为input时需要
     */
    @ApiModelProperty(value = "输入值 操作为input时需要",example = "ty")
    @JSONField(ordinal = 6)
    private String value;

    /**
     * 判断类型
     */
    @ApiModelProperty(value = "判断类型",example = "value",notes = "目前有2种:value-当前元素的值 title-页面标题")
    @JSONField(ordinal = 7)
    private String assertion;

    /**
     * 期望结果
     */
    @ApiModelProperty(value = "期望结果",example = "ty")
    @JSONField(ordinal = 8)
    private String expected;

}
