package com.zjty.automatedtesting.pojo.test;

import com.zjty.automatedtesting.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.List;

@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试用例")
public class TestCaseVo {

    @ApiModelProperty(value = "主键",example = "1")
    Integer id;
    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器",example = "firefox")
    String browser;

    /**
     * 起始网站
     */
    @ApiModelProperty(value = "网站地址",example = "http://www.baidu.com")
    String url;

    /**
     * 步骤详情
     */
    @ApiModelProperty(value = "步骤详情")
    List<Step> steps;

}
