package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.test.TestCase;
import com.zjty.automatedtesting.pojo.test.TestCaseVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface TestCaseService {

    /**
     * 保存测试用例
     * 不附带id为新增
     * 附带id为修改
     * @param testCaseVo testCaseVo
     */
    void save(TestCaseVo testCaseVo);

    /**
     * 指定id删除测试用例
     * @param id id
     */
    void delete(Integer id);

    /**
     * 查询所有测试用例
     * @return list
     */
    List<TestCaseVo> findAll();

    /**
     * 指定id查询测试用例
     * @param id id
     * @return testcase
     */
    TestCaseVo findById(Integer id);

}
