package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.test.TestCase;
import com.zjty.automatedtesting.pojo.test.TestCaseVo;
import com.zjty.automatedtesting.repository.TestCaseRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@Service
public class TestCaseServiceImpl implements TestCaseService {

    @Autowired
    TestCaseRepository repository;

    @Autowired
    TransHelper transHelper;

    @Override
    public void save(TestCaseVo testCaseVo) {
        TestCase testCase = transHelper.toDo(testCaseVo);
        if (Objects.isNull(testCase.getId())){
            repository.save(testCase);
        }else if(repository.existsById(testCase.getId())){
            repository.save(testCase);
        }else {
            throw new RuntimeException("指定的id不存在："+testCase.getId());
        }
    }

    @Override
    public void delete(Integer id) {
        if (repository.existsById(id)){
            repository.deleteById(id);
        } else {
            throw new RuntimeException("指定的id不存在："+id);
        }
    }

    @Override
    public List<TestCaseVo> findAll() {
        return repository.findAll().stream().map(transHelper::toVo).collect(Collectors.toList());
    }

    @Override
    public TestCaseVo findById(Integer id) {
        Optional<TestCaseVo> testCaseVo = repository.findById(id).map(transHelper::toVo);
        if (testCaseVo.isPresent()) {
            return testCaseVo.get();
        }else {
            throw new RuntimeException("指定的id不存在："+id);
        }
    }

}
