package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.test.Step;
import com.zjty.automatedtesting.pojo.test.TestCase;
import com.zjty.automatedtesting.pojo.test.TestCaseVo;
import com.zjty.automatedtesting.util.JsonUtil;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TransHelper {

    public TestCase toDo(TestCaseVo testCaseVo){
        String steps = JsonUtil.toJSon(testCaseVo.getSteps());
        return new TestCase(
                testCaseVo.getId(),
                testCaseVo.getBrowser(),
                testCaseVo.getUrl(),
                steps
        );
    }

    public TestCaseVo toVo(TestCase testCase){
        List<Step> steps = JsonUtil.readValueToList(testCase.getSteps(),Step.class);
        return new TestCaseVo(
                testCase.getId(),
                testCase.getBrowser(),
                testCase.getUrl(),
                steps
        );
    }

}
