package com.zjty.automatedtesting.controller;


import com.zjty.automatedtesting.pojo.test.System;
import com.zjty.automatedtesting.pojo.test.SystemVo;
import com.zjty.automatedtesting.service.SystemService;
import com.zjty.automatedtesting.service.impl.TransHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@RequestMapping("/system")
@RestController
@Api(tags = "测试系统")
@CrossOrigin
public class SystemController {

    @Autowired
    SystemService systemService;

    @Autowired
    TransHelper transHelper;

    @ApiOperation(value = "新增测试系统.")
    @PostMapping(value="/create")
    public ResponseEntity<System> create(@RequestBody System system){
        system = systemService.create(system);
        return ResponseEntity.ok(system);
    }

    @ApiOperation(value = "根据id获取测试系统.")
    @GetMapping(value="/get/{id}")
    public ResponseEntity<SystemVo> findById(@PathVariable String id){
        System system = systemService.findById(id);
        SystemVo result = transHelper.toSystemVo(system);
        return ResponseEntity.ok(result);
    }

}
