package com.zjty.automatedtesting.pojo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "测试报告结果")
public class ReportVo {

    @ApiModelProperty(value = "主键id",example = "1")
    private Integer id;

    @ApiModelProperty(value = "测试用例标题",example = "百度一下",position = 1)
    private String title;

    /**
     * 浏览器
     */
    @ApiModelProperty(value = "浏览器",example = "firefox",position = 2)
    private String browser;

    /**
     * 网站地址
     */
    @ApiModelProperty(value = "网站地址",example = "http://www.baidu.com",position = 3)
    private String url;

    /**
     * 每个步骤结果详情
     */
    @ApiModelProperty(value = "每个步骤结果详情",position = 4)
    private List<Measure> measures;

}
