package com.zjty.automatedtesting.service;

import com.zjty.automatedtesting.pojo.report.Report;
import com.zjty.automatedtesting.pojo.report.ReportVo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface ReportService {

    /**
     * 保存 测试报告
     *
     * @return 保存的id
     */
    Integer save(Report report);

    /**
     * 查询所有
     *
     * @return 集合形式的测试报告
     */
    List<ReportVo> findAll();

    /**
     * 按分页查询
     * 每页10个
     * @param page 页码 从0开始
     * @return 集合形式的测试报告
     */
    List<ReportVo> findByPage(Integer page);

    /**
     * 根据所属测试用例的id查询测试报告
     *
     * @param caseId 测试用例的id
     * @return 该测试用例执行后生成的所有报告的集合形式
     */
    List<ReportVo> findByCaseId(Integer caseId);

    /**
     * 按id查询单个
     *
     * @param id 指定id
     * @return 单个测试报告
     * 报告
     */
    ReportVo findById(Integer id);

    /**
     * 指定id删除
     *
     * @param id 指定的id
     */
    void delete(Integer id);

}
