package com.zjty.automatedtesting.service.impl;

import com.zjty.automatedtesting.pojo.test.System;
import com.zjty.automatedtesting.repository.SystemRepository;
import com.zjty.automatedtesting.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;

@SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
@Service
public class SystemServiceImpl implements SystemService {

    @Autowired
    SystemRepository repository;

    @Override
    public System create(System system) {
        if (isNull(system.getId())) {
            return repository.save(system);
        }else {
            throw new RuntimeException("新增数据不可附带id");
        }
    }

    @Override
    public System update(System system) {
        if (nonNull(system.getId())) {
            return repository.save(system);
        }else {
            throw new RuntimeException("新增数据必须附带id");
        }
    }

    @Override
    public System findById(String id) {
        return repository.findById(id).orElseThrow(() -> new RuntimeException("未找到该id的测试系统"));
    }

}
