package com.example.printer;

import com.google.zxing.*;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.HashMap;
import java.util.Map;

/**
 * 条形码生成工具
 */
public class BarCodeUtil {

    /**
     * 保存格式
     */
    private static String format = "png";

    /**
     * 生成条形码图片文件
     */
    public static void createBarCodeImgFile(String text, Integer width, Integer height, String barPath) {
        try {
            Map<EncodeHintType, Object> hints = getDecodeHintType();
            BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.CODE_128, width, height, hints);
            File file = new File(barPath);
            BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            ImageIO.write(image, format, file);
            MatrixToImageWriter.writeToFile(bitMatrix, format, file);
        } catch (WriterException | IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 生成条形码图片对象
     */
    public static BufferedImage createBarCodeImg(String text, Integer width, Integer height) {
        try {

            Map<EncodeHintType, Object> hints = getDecodeHintType();
            BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.CODE_128, width, height, hints);
            BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    image.setRGB(x, y, rgb(bitMatrix.get(x, y)));
                }
            }
            return image;
        } catch (WriterException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 生成条形码输出流
     */
    private static void createBarCode(String text, Integer width, Integer height, OutputStream out) {
        try {
            Map<EncodeHintType, Object> hints = getDecodeHintType();
            BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.CODE_128, width, height, hints);
            MatrixToImageWriter.writeToStream(bitMatrix, format, out);
        } catch (WriterException | IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 针对条形码进行解析
     */
    public static String decodeBar(String imgPath) {
        BufferedImage image;
        Result result;
        try {
            image = ImageIO.read(new File(imgPath));
            if (image == null) {
                System.out.println("the decode image may be not exit.");
            }
            LuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));

            result = new MultiFormatReader().decode(bitmap, null);
            System.out.println(result.getText());
            return result.getText();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 二维码的格式参数
     */
    private static Map<EncodeHintType, Object> getDecodeHintType() {
        // 用于设置QR二维码参数
        Map<EncodeHintType, Object> hints = new HashMap<>();
        //设置QR二维码的纠错级别（H为最高级别）具体级别信息
        //二维码容错率 L = ~7% /M = ~15% /Q = ~25% /H = ~30% 容错率越高,二维码的有效像素点就越多
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
         //白边大小，取值范围0~4
        Integer margin = 1;
        hints.put(EncodeHintType.MARGIN, margin);
        // 设置编码方式
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        return hints;
    }

    private static Integer rgb(boolean point) {
        return point ? 0 : 16777215;
    }
}
