package com.example.printer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;


/**
 * 打印机工具 调用打印机并传输ZPL码 打印图片
 */
public class PrinterUtil {

    private static String address = "192.168.1.200";
    private static int portNumber = 9100;

    private static Socket socket = null;
    private static PrintWriter printWriter;
    private static BufferedReader bufferedReader;

    private static void connect() {
        if (isNull(socket)) {
            try {
                socket = new Socket(address, portNumber);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nonNull(socket) && !socket.isConnected()) {
            try {
                socket.connect(new InetSocketAddress(address, portNumber));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void execute(String code) {
        connect();
        try {

            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printWriter = new PrintWriter(socket.getOutputStream());
            printWriter.println(
                    code
            );
            printWriter.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        if (nonNull(socket)) {
            try {
                socket.close();
                printWriter.close();
                bufferedReader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
