package com.tykj.datahouse.controller;

import com.tykj.datahouse.base.result.ResultObj;
import com.tykj.datahouse.base.result.ResultUtil;
import com.tykj.datahouse.service.TableInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;


@Api(tags = "数据操作API")
@CrossOrigin
@RequestMapping("/data")
@RestController
public class DataController {

    @Autowired
    private TableInfoService tableInfoService;


    @PostMapping("/{tableId}")
    @ApiOperation("在指定表中新插入一条数据")
    public ResponseEntity<ResultObj<Object>> createTable(@PathVariable Integer tableId, @RequestBody Map<String, Object> row) {
        tableInfoService.insertData(tableId, row);
        return ResultUtil.success("操作成功");
    }

    @PutMapping("/{tableId}")
    @ApiOperation("在指定表中修改一条数据")
    public ResponseEntity<ResultObj<Object>> alterTable(@PathVariable Integer tableId, @RequestBody Map<String, Object> row) {
        tableInfoService.updateData(tableId, row);
        return ResultUtil.success("操作成功");
    }

    @DeleteMapping("/{tableId}")
    @ApiOperation("在指定表中删除一条数据")
    public ResponseEntity<ResultObj<Object>> dropTable(@PathVariable Integer tableId, @RequestBody Map<String, Object> row) {
        tableInfoService.deleteData(tableId, row);
        return ResultUtil.success("操作成功");
    }


}
